/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SharedGalleryImageVersionStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class CommunityGalleryImageVersionProperties
implements JsonSerializable<CommunityGalleryImageVersionProperties> {
    private OffsetDateTime publishedDate;
    private OffsetDateTime endOfLifeDate;
    private Boolean excludeFromLatest;
    private SharedGalleryImageVersionStorageProfile storageProfile;
    private String disclaimer;
    private Map<String, String> artifactTags;

    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    public CommunityGalleryImageVersionProperties withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public CommunityGalleryImageVersionProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public CommunityGalleryImageVersionProperties withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public SharedGalleryImageVersionStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public CommunityGalleryImageVersionProperties withStorageProfile(SharedGalleryImageVersionStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String disclaimer() {
        return this.disclaimer;
    }

    public CommunityGalleryImageVersionProperties withDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    public CommunityGalleryImageVersionProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publishedDate", this.publishedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.publishedDate));
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeStringField("disclaimer", this.disclaimer);
        jsonWriter.writeMapField("artifactTags", this.artifactTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CommunityGalleryImageVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CommunityGalleryImageVersionProperties)jsonReader.readObject(reader -> {
            CommunityGalleryImageVersionProperties deserializedCommunityGalleryImageVersionProperties = new CommunityGalleryImageVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publishedDate".equals(fieldName)) {
                    deserializedCommunityGalleryImageVersionProperties.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedCommunityGalleryImageVersionProperties.endOfLifeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedCommunityGalleryImageVersionProperties.excludeFromLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedCommunityGalleryImageVersionProperties.storageProfile = SharedGalleryImageVersionStorageProfile.fromJson(reader);
                    continue;
                }
                if ("disclaimer".equals(fieldName)) {
                    deserializedCommunityGalleryImageVersionProperties.disclaimer = reader.getString();
                    continue;
                }
                if ("artifactTags".equals(fieldName)) {
                    Map artifactTags;
                    deserializedCommunityGalleryImageVersionProperties.artifactTags = artifactTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunityGalleryImageVersionProperties;
        });
    }
}

