// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The protection policy of a virtual machine scale set VM.
 */
@Fluent
public final class VirtualMachineScaleSetVMProtectionPolicy
    implements JsonSerializable<VirtualMachineScaleSetVMProtectionPolicy> {
    /*
     * Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
     */
    private Boolean protectFromScaleIn;

    /*
     * Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should
     * not be applied to the virtual machine scale set VM.
     */
    private Boolean protectFromScaleSetActions;

    /**
     * Creates an instance of VirtualMachineScaleSetVMProtectionPolicy class.
     */
    public VirtualMachineScaleSetVMProtectionPolicy() {
    }

    /**
     * Get the protectFromScaleIn property: Indicates that the virtual machine scale set VM shouldn't be considered for
     * deletion during a scale-in operation.
     * 
     * @return the protectFromScaleIn value.
     */
    public Boolean protectFromScaleIn() {
        return this.protectFromScaleIn;
    }

    /**
     * Set the protectFromScaleIn property: Indicates that the virtual machine scale set VM shouldn't be considered for
     * deletion during a scale-in operation.
     * 
     * @param protectFromScaleIn the protectFromScaleIn value to set.
     * @return the VirtualMachineScaleSetVMProtectionPolicy object itself.
     */
    public VirtualMachineScaleSetVMProtectionPolicy withProtectFromScaleIn(Boolean protectFromScaleIn) {
        this.protectFromScaleIn = protectFromScaleIn;
        return this;
    }

    /**
     * Get the protectFromScaleSetActions property: Indicates that model updates or actions (including scale-in)
     * initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
     * 
     * @return the protectFromScaleSetActions value.
     */
    public Boolean protectFromScaleSetActions() {
        return this.protectFromScaleSetActions;
    }

    /**
     * Set the protectFromScaleSetActions property: Indicates that model updates or actions (including scale-in)
     * initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
     * 
     * @param protectFromScaleSetActions the protectFromScaleSetActions value to set.
     * @return the VirtualMachineScaleSetVMProtectionPolicy object itself.
     */
    public VirtualMachineScaleSetVMProtectionPolicy withProtectFromScaleSetActions(Boolean protectFromScaleSetActions) {
        this.protectFromScaleSetActions = protectFromScaleSetActions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("protectFromScaleIn", this.protectFromScaleIn);
        jsonWriter.writeBooleanField("protectFromScaleSetActions", this.protectFromScaleSetActions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMProtectionPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMProtectionPolicy if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMProtectionPolicy.
     */
    public static VirtualMachineScaleSetVMProtectionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMProtectionPolicy deserializedVirtualMachineScaleSetVMProtectionPolicy
                = new VirtualMachineScaleSetVMProtectionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protectFromScaleIn".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProtectionPolicy.protectFromScaleIn
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("protectFromScaleSetActions".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProtectionPolicy.protectFromScaleSetActions
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMProtectionPolicy;
        });
    }
}
