// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Refers to the security capability of the disk supported to create a Trusted launch or Confidential VM.
 */
public final class SupportedSecurityOption extends ExpandableStringEnum<SupportedSecurityOption> {
    /**
     * Static value TrustedLaunchSupported for SupportedSecurityOption.
     */
    public static final SupportedSecurityOption TRUSTED_LAUNCH_SUPPORTED = fromString("TrustedLaunchSupported");

    /**
     * Static value TrustedLaunchAndConfidentialVMSupported for SupportedSecurityOption.
     */
    public static final SupportedSecurityOption TRUSTED_LAUNCH_AND_CONFIDENTIAL_VMSUPPORTED
        = fromString("TrustedLaunchAndConfidentialVMSupported");

    /**
     * Creates a new instance of SupportedSecurityOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SupportedSecurityOption() {
    }

    /**
     * Creates or finds a SupportedSecurityOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SupportedSecurityOption.
     */
    public static SupportedSecurityOption fromString(String name) {
        return fromString(name, SupportedSecurityOption.class);
    }

    /**
     * Gets known SupportedSecurityOption values.
     * 
     * @return known SupportedSecurityOption values.
     */
    public static Collection<SupportedSecurityOption> values() {
        return values(SupportedSecurityOption.class);
    }
}
