// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Galleries operation response.
 */
@Fluent
public final class GalleryList implements JsonSerializable<GalleryList> {
    /*
     * A list of galleries.
     */
    private List<GalleryInner> value;

    /*
     * The uri to fetch the next page of galleries. Call ListNext() with this to fetch the next page of galleries.
     */
    private String nextLink;

    /*
     * The security profile of a gallery image version
     */
    private ImageVersionSecurityProfile securityProfile;

    /**
     * Creates an instance of GalleryList class.
     */
    public GalleryList() {
    }

    /**
     * Get the value property: A list of galleries.
     * 
     * @return the value value.
     */
    public List<GalleryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of galleries.
     * 
     * @param value the value value to set.
     * @return the GalleryList object itself.
     */
    public GalleryList withValue(List<GalleryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of galleries. Call ListNext() with this to fetch the
     * next page of galleries.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of galleries. Call ListNext() with this to fetch the
     * next page of galleries.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryList object itself.
     */
    public GalleryList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the securityProfile property: The security profile of a gallery image version.
     * 
     * @return the securityProfile value.
     */
    public ImageVersionSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: The security profile of a gallery image version.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the GalleryList object itself.
     */
    public GalleryList withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model GalleryList"));
        } else {
            value().forEach(e -> e.validate());
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryList.
     */
    public static GalleryList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryList deserializedGalleryList = new GalleryList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GalleryInner> value = reader.readArray(reader1 -> GalleryInner.fromJson(reader1));
                    deserializedGalleryList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGalleryList.nextLink = reader.getString();
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedGalleryList.securityProfile = ImageVersionSecurityProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryList;
        });
    }
}
