// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies the input for attaching and detaching a list of managed data disks.
 */
@Fluent
public final class AttachDetachDataDisksRequest implements JsonSerializable<AttachDetachDataDisksRequest> {
    /*
     * The list of managed data disks to be attached.
     */
    private List<DataDisksToAttach> dataDisksToAttach;

    /*
     * The list of managed data disks to be detached.
     */
    private List<DataDisksToDetach> dataDisksToDetach;

    /**
     * Creates an instance of AttachDetachDataDisksRequest class.
     */
    public AttachDetachDataDisksRequest() {
    }

    /**
     * Get the dataDisksToAttach property: The list of managed data disks to be attached.
     * 
     * @return the dataDisksToAttach value.
     */
    public List<DataDisksToAttach> dataDisksToAttach() {
        return this.dataDisksToAttach;
    }

    /**
     * Set the dataDisksToAttach property: The list of managed data disks to be attached.
     * 
     * @param dataDisksToAttach the dataDisksToAttach value to set.
     * @return the AttachDetachDataDisksRequest object itself.
     */
    public AttachDetachDataDisksRequest withDataDisksToAttach(List<DataDisksToAttach> dataDisksToAttach) {
        this.dataDisksToAttach = dataDisksToAttach;
        return this;
    }

    /**
     * Get the dataDisksToDetach property: The list of managed data disks to be detached.
     * 
     * @return the dataDisksToDetach value.
     */
    public List<DataDisksToDetach> dataDisksToDetach() {
        return this.dataDisksToDetach;
    }

    /**
     * Set the dataDisksToDetach property: The list of managed data disks to be detached.
     * 
     * @param dataDisksToDetach the dataDisksToDetach value to set.
     * @return the AttachDetachDataDisksRequest object itself.
     */
    public AttachDetachDataDisksRequest withDataDisksToDetach(List<DataDisksToDetach> dataDisksToDetach) {
        this.dataDisksToDetach = dataDisksToDetach;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataDisksToAttach() != null) {
            dataDisksToAttach().forEach(e -> e.validate());
        }
        if (dataDisksToDetach() != null) {
            dataDisksToDetach().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dataDisksToAttach", this.dataDisksToAttach,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("dataDisksToDetach", this.dataDisksToDetach,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AttachDetachDataDisksRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AttachDetachDataDisksRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AttachDetachDataDisksRequest.
     */
    public static AttachDetachDataDisksRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AttachDetachDataDisksRequest deserializedAttachDetachDataDisksRequest = new AttachDetachDataDisksRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataDisksToAttach".equals(fieldName)) {
                    List<DataDisksToAttach> dataDisksToAttach
                        = reader.readArray(reader1 -> DataDisksToAttach.fromJson(reader1));
                    deserializedAttachDetachDataDisksRequest.dataDisksToAttach = dataDisksToAttach;
                } else if ("dataDisksToDetach".equals(fieldName)) {
                    List<DataDisksToDetach> dataDisksToDetach
                        = reader.readArray(reader1 -> DataDisksToDetach.fromJson(reader1));
                    deserializedAttachDetachDataDisksRequest.dataDisksToDetach = dataDisksToDetach;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAttachDetachDataDisksRequest;
        });
    }
}
