// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.VirtualMachineScaleSetVMRunCommandsClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineRunCommandInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandUpdate;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualMachineScaleSetVMRunCommandsClient.
 */
public final class VirtualMachineScaleSetVMRunCommandsClientImpl implements VirtualMachineScaleSetVMRunCommandsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final VirtualMachineScaleSetVMRunCommandsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of VirtualMachineScaleSetVMRunCommandsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    VirtualMachineScaleSetVMRunCommandsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(VirtualMachineScaleSetVMRunCommandsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientVirtualMachineScaleSetVMRunCommands to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementClientVirtualMachineScaleSetVMRunCommands")
    public interface VirtualMachineScaleSetVMRunCommandsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandsListResult>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("vmScaleSetName") String vmScaleSetName, @PathParam("instanceId") String instanceId,
            @QueryParam("$expand") String expand, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("vmScaleSetName") String vmScaleSetName, @PathParam("instanceId") String instanceId,
            @PathParam("runCommandName") String runCommandName, @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("vmScaleSetName") String vmScaleSetName, @PathParam("instanceId") String instanceId,
            @PathParam("runCommandName") String runCommandName,
            @BodyParam("application/json") VirtualMachineRunCommandInner runCommand,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("vmScaleSetName") String vmScaleSetName, @PathParam("instanceId") String instanceId,
            @PathParam("runCommandName") String runCommandName,
            @BodyParam("application/json") VirtualMachineRunCommandUpdate runCommand,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("vmScaleSetName") String vmScaleSetName, @PathParam("instanceId") String instanceId,
            @PathParam("runCommandName") String runCommandName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineRunCommandsListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listSinglePageAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, vmScaleSetName, instanceId, expand, accept, context))
            .<PagedResponse<VirtualMachineRunCommandInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listSinglePageAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
                vmScaleSetName, instanceId, expand, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String expand) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId) {
        final String expand = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineRunCommandInner> listAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String expand, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> list(String resourceGroupName, String vmScaleSetName,
        String instanceId) {
        final String expand = null;
        return new PagedIterable<>(listAsync(resourceGroupName, vmScaleSetName, instanceId, expand));
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> list(String resourceGroupName, String vmScaleSetName,
        String instanceId, String expand, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, vmScaleSetName, instanceId, expand, context));
    }

    /**
     * The operation to get the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VirtualMachineRunCommandInner>> getWithResponseAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to get the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VirtualMachineRunCommandInner>> getWithResponseAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String runCommandName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            vmScaleSetName, instanceId, runCommandName, expand, accept, context);
    }

    /**
     * The operation to get the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName) {
        final String expand = null;
        return getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The operation to get the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VirtualMachineRunCommandInner> getWithResponse(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, String expand, Context context) {
        return getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand, context)
            .block();
    }

    /**
     * The operation to get the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner get(String resourceGroupName, String vmScaleSetName, String instanceId,
        String runCommandName) {
        final String expand = null;
        return getWithResponse(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand, Context.NONE)
            .getValue();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, vmScaleSetName, instanceId, runCommandName,
                runCommand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, accept, context);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId,
            String runCommandName, VirtualMachineRunCommandInner runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName,
            instanceId, runCommandName, runCommand);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            this.client.getContext());
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId,
            String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName,
            instanceId, runCommandName, runCommand, context);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            context);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand)
            .getSyncPoller();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandInner runCommand, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand,
                context)
            .getSyncPoller();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).block();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return createOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, context)
            .block();
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        } else {
            runCommand.validate();
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            vmScaleSetName, instanceId, runCommandName, runCommand, accept, context);
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            this.client.getContext());
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId,
            runCommandName, runCommand, context);
        return this.client.<VirtualMachineRunCommandInner, VirtualMachineRunCommandInner>getLroResult(mono,
            this.client.getHttpPipeline(), VirtualMachineRunCommandInner.class, VirtualMachineRunCommandInner.class,
            context);
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand)
            .getSyncPoller();
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, context)
            .getSyncPoller();
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmScaleSetName, String instanceId,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return updateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).block();
    }

    /**
     * The operation to update the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmScaleSetName, String instanceId,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return updateAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand, context).block();
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, vmScaleSetName, instanceId, runCommandName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error(new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        final String apiVersion = "2024-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            vmScaleSetName, instanceId, runCommandName, accept, context);
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).getSyncPoller();
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName,
        String instanceId, String runCommandName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, context)
            .getSyncPoller();
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId,
        String runCommandName) {
        return beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId,
        String runCommandName, Context context) {
        return beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        deleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).block();
    }

    /**
     * The operation to delete the VMSS VM run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmScaleSetName The name of the VirtualMachineScaleSet.
     * @param instanceId The name of the VirtualMachineScaleSetVM.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName,
        Context context) {
        deleteAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<VirtualMachineRunCommandInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
