// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CopyCompletionError;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.DiskPurchasePlan;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.SnapshotAccessState;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Snapshot resource properties.
 */
@Fluent
public final class SnapshotProperties implements JsonSerializable<SnapshotProperties> {
    /*
     * The time when the snapshot was created.
     */
    private OffsetDateTime timeCreated;

    /*
     * The Operating System type.
     */
    private OperatingSystemTypes osType;

    /*
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    private HyperVGeneration hyperVGeneration;

    /*
     * Purchase plan information for the image from which the source disk for the snapshot was originally created.
     */
    private DiskPurchasePlan purchasePlan;

    /*
     * List of supported capabilities for the image from which the source disk from the snapshot was originally created.
     */
    private SupportedCapabilities supportedCapabilities;

    /*
     * Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    private CreationData creationData;

    /*
     * If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create.
     * If this field is present for updates or creation with other options, it indicates a resize. Resizes are only
     * allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    private Integer diskSizeGB;

    /*
     * The size of the disk in bytes. This field is read only.
     */
    private Long diskSizeBytes;

    /*
     * The state of the snapshot.
     */
    private DiskState diskState;

    /*
     * Unique Guid identifying the resource.
     */
    private String uniqueId;

    /*
     * Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk
     * or snapshot.
     */
    private EncryptionSettingsCollection encryptionSettingsCollection;

    /*
     * The disk provisioning state.
     */
    private String provisioningState;

    /*
     * Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots
     * and can be diffed.
     */
    private Boolean incremental;

    /*
     * Incremental snapshots for a disk share an incremental snapshot family id. The Get Page Range Diff API can only be
     * called on incremental snapshots with the same family id.
     */
    private String incrementalSnapshotFamilyId;

    /*
     * Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    private Encryption encryption;

    /*
     * Policy for accessing the disk via network.
     */
    private NetworkAccessPolicy networkAccessPolicy;

    /*
     * ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    private String diskAccessId;

    /*
     * Contains the security related information for the resource.
     */
    private DiskSecurityProfile securityProfile;

    /*
     * Indicates the OS on a snapshot supports hibernation.
     */
    private Boolean supportsHibernation;

    /*
     * Policy for controlling export on the disk.
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    private Float completionPercent;

    /*
     * Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
     */
    private CopyCompletionError copyCompletionError;

    /*
     * Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    private DataAccessAuthMode dataAccessAuthMode;

    /*
     * The state of snapshot which determines the access availability of the snapshot.
     */
    private SnapshotAccessState snapshotAccessState;

    /**
     * Creates an instance of SnapshotProperties class.
     */
    public SnapshotProperties() {
    }

    /**
     * Get the timeCreated property: The time when the snapshot was created.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the osType property: The Operating System type.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The Operating System type.
     * 
     * @param osType the osType value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @return the hyperVGeneration value.
     */
    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @param hyperVGeneration the hyperVGeneration value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Get the purchasePlan property: Purchase plan information for the image from which the source disk for the
     * snapshot was originally created.
     * 
     * @return the purchasePlan value.
     */
    public DiskPurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    /**
     * Set the purchasePlan property: Purchase plan information for the image from which the source disk for the
     * snapshot was originally created.
     * 
     * @param purchasePlan the purchasePlan value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withPurchasePlan(DiskPurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    /**
     * Get the supportedCapabilities property: List of supported capabilities for the image from which the source disk
     * from the snapshot was originally created.
     * 
     * @return the supportedCapabilities value.
     */
    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    /**
     * Set the supportedCapabilities property: List of supported capabilities for the image from which the source disk
     * from the snapshot was originally created.
     * 
     * @param supportedCapabilities the supportedCapabilities value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    /**
     * Get the creationData property: Disk source information. CreationData information cannot be changed after the disk
     * has been created.
     * 
     * @return the creationData value.
     */
    public CreationData creationData() {
        return this.creationData;
    }

    /**
     * Set the creationData property: Disk source information. CreationData information cannot be changed after the disk
     * has been created.
     * 
     * @param creationData the creationData value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    /**
     * Get the diskSizeGB property: If creationData.createOption is Empty, this field is mandatory and it indicates the
     * size of the disk to create. If this field is present for updates or creation with other options, it indicates a
     * resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's
     * size.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: If creationData.createOption is Empty, this field is mandatory and it indicates the
     * size of the disk to create. If this field is present for updates or creation with other options, it indicates a
     * resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's
     * size.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the diskSizeBytes property: The size of the disk in bytes. This field is read only.
     * 
     * @return the diskSizeBytes value.
     */
    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    /**
     * Get the diskState property: The state of the snapshot.
     * 
     * @return the diskState value.
     */
    public DiskState diskState() {
        return this.diskState;
    }

    /**
     * Get the uniqueId property: Unique Guid identifying the resource.
     * 
     * @return the uniqueId value.
     */
    public String uniqueId() {
        return this.uniqueId;
    }

    /**
     * Get the encryptionSettingsCollection property: Encryption settings collection used be Azure Disk Encryption, can
     * contain multiple encryption settings per disk or snapshot.
     * 
     * @return the encryptionSettingsCollection value.
     */
    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    /**
     * Set the encryptionSettingsCollection property: Encryption settings collection used be Azure Disk Encryption, can
     * contain multiple encryption settings per disk or snapshot.
     * 
     * @param encryptionSettingsCollection the encryptionSettingsCollection value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties
        withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    /**
     * Get the provisioningState property: The disk provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the incremental property: Whether a snapshot is incremental. Incremental snapshots on the same disk occupy
     * less space than full snapshots and can be diffed.
     * 
     * @return the incremental value.
     */
    public Boolean incremental() {
        return this.incremental;
    }

    /**
     * Set the incremental property: Whether a snapshot is incremental. Incremental snapshots on the same disk occupy
     * less space than full snapshots and can be diffed.
     * 
     * @param incremental the incremental value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    /**
     * Get the incrementalSnapshotFamilyId property: Incremental snapshots for a disk share an incremental snapshot
     * family id. The Get Page Range Diff API can only be called on incremental snapshots with the same family id.
     * 
     * @return the incrementalSnapshotFamilyId value.
     */
    public String incrementalSnapshotFamilyId() {
        return this.incrementalSnapshotFamilyId;
    }

    /**
     * Get the encryption property: Encryption property can be used to encrypt data at rest with customer managed keys
     * or platform managed keys.
     * 
     * @return the encryption value.
     */
    public Encryption encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: Encryption property can be used to encrypt data at rest with customer managed keys
     * or platform managed keys.
     * 
     * @param encryption the encryption value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the networkAccessPolicy property: Policy for accessing the disk via network.
     * 
     * @return the networkAccessPolicy value.
     */
    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    /**
     * Set the networkAccessPolicy property: Policy for accessing the disk via network.
     * 
     * @param networkAccessPolicy the networkAccessPolicy value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    /**
     * Get the diskAccessId property: ARM id of the DiskAccess resource for using private endpoints on disks.
     * 
     * @return the diskAccessId value.
     */
    public String diskAccessId() {
        return this.diskAccessId;
    }

    /**
     * Set the diskAccessId property: ARM id of the DiskAccess resource for using private endpoints on disks.
     * 
     * @param diskAccessId the diskAccessId value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    /**
     * Get the securityProfile property: Contains the security related information for the resource.
     * 
     * @return the securityProfile value.
     */
    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: Contains the security related information for the resource.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the supportsHibernation property: Indicates the OS on a snapshot supports hibernation.
     * 
     * @return the supportsHibernation value.
     */
    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    /**
     * Set the supportsHibernation property: Indicates the OS on a snapshot supports hibernation.
     * 
     * @param supportsHibernation the supportsHibernation value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Policy for controlling export on the disk.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Policy for controlling export on the disk.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the completionPercent property: Percentage complete for the background copy when a resource is created via
     * the CopyStart operation.
     * 
     * @return the completionPercent value.
     */
    public Float completionPercent() {
        return this.completionPercent;
    }

    /**
     * Set the completionPercent property: Percentage complete for the background copy when a resource is created via
     * the CopyStart operation.
     * 
     * @param completionPercent the completionPercent value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    /**
     * Get the copyCompletionError property: Indicates the error details if the background copy of a resource created
     * via the CopyStart operation fails.
     * 
     * @return the copyCompletionError value.
     */
    public CopyCompletionError copyCompletionError() {
        return this.copyCompletionError;
    }

    /**
     * Set the copyCompletionError property: Indicates the error details if the background copy of a resource created
     * via the CopyStart operation fails.
     * 
     * @param copyCompletionError the copyCompletionError value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withCopyCompletionError(CopyCompletionError copyCompletionError) {
        this.copyCompletionError = copyCompletionError;
        return this;
    }

    /**
     * Get the dataAccessAuthMode property: Additional authentication requirements when exporting or uploading to a disk
     * or snapshot.
     * 
     * @return the dataAccessAuthMode value.
     */
    public DataAccessAuthMode dataAccessAuthMode() {
        return this.dataAccessAuthMode;
    }

    /**
     * Set the dataAccessAuthMode property: Additional authentication requirements when exporting or uploading to a disk
     * or snapshot.
     * 
     * @param dataAccessAuthMode the dataAccessAuthMode value to set.
     * @return the SnapshotProperties object itself.
     */
    public SnapshotProperties withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        this.dataAccessAuthMode = dataAccessAuthMode;
        return this;
    }

    /**
     * Get the snapshotAccessState property: The state of snapshot which determines the access availability of the
     * snapshot.
     * 
     * @return the snapshotAccessState value.
     */
    public SnapshotAccessState snapshotAccessState() {
        return this.snapshotAccessState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (purchasePlan() != null) {
            purchasePlan().validate();
        }
        if (supportedCapabilities() != null) {
            supportedCapabilities().validate();
        }
        if (creationData() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property creationData in model SnapshotProperties"));
        } else {
            creationData().validate();
        }
        if (encryptionSettingsCollection() != null) {
            encryptionSettingsCollection().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (copyCompletionError() != null) {
            copyCompletionError().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SnapshotProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("creationData", this.creationData);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("hyperVGeneration",
            this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("purchasePlan", this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", this.supportedCapabilities);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeJsonField("encryptionSettingsCollection", this.encryptionSettingsCollection);
        jsonWriter.writeBooleanField("incremental", this.incremental);
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeStringField("networkAccessPolicy",
            this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeNumberField("completionPercent", this.completionPercent);
        jsonWriter.writeJsonField("copyCompletionError", this.copyCompletionError);
        jsonWriter.writeStringField("dataAccessAuthMode",
            this.dataAccessAuthMode == null ? null : this.dataAccessAuthMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnapshotProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnapshotProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SnapshotProperties.
     */
    public static SnapshotProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotProperties deserializedSnapshotProperties = new SnapshotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("creationData".equals(fieldName)) {
                    deserializedSnapshotProperties.creationData = CreationData.fromJson(reader);
                } else if ("timeCreated".equals(fieldName)) {
                    deserializedSnapshotProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("osType".equals(fieldName)) {
                    deserializedSnapshotProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                } else if ("hyperVGeneration".equals(fieldName)) {
                    deserializedSnapshotProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                } else if ("purchasePlan".equals(fieldName)) {
                    deserializedSnapshotProperties.purchasePlan = DiskPurchasePlan.fromJson(reader);
                } else if ("supportedCapabilities".equals(fieldName)) {
                    deserializedSnapshotProperties.supportedCapabilities = SupportedCapabilities.fromJson(reader);
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedSnapshotProperties.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("diskSizeBytes".equals(fieldName)) {
                    deserializedSnapshotProperties.diskSizeBytes = reader.getNullable(JsonReader::getLong);
                } else if ("diskState".equals(fieldName)) {
                    deserializedSnapshotProperties.diskState = DiskState.fromString(reader.getString());
                } else if ("uniqueId".equals(fieldName)) {
                    deserializedSnapshotProperties.uniqueId = reader.getString();
                } else if ("encryptionSettingsCollection".equals(fieldName)) {
                    deserializedSnapshotProperties.encryptionSettingsCollection
                        = EncryptionSettingsCollection.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSnapshotProperties.provisioningState = reader.getString();
                } else if ("incremental".equals(fieldName)) {
                    deserializedSnapshotProperties.incremental = reader.getNullable(JsonReader::getBoolean);
                } else if ("incrementalSnapshotFamilyId".equals(fieldName)) {
                    deserializedSnapshotProperties.incrementalSnapshotFamilyId = reader.getString();
                } else if ("encryption".equals(fieldName)) {
                    deserializedSnapshotProperties.encryption = Encryption.fromJson(reader);
                } else if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedSnapshotProperties.networkAccessPolicy
                        = NetworkAccessPolicy.fromString(reader.getString());
                } else if ("diskAccessId".equals(fieldName)) {
                    deserializedSnapshotProperties.diskAccessId = reader.getString();
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedSnapshotProperties.securityProfile = DiskSecurityProfile.fromJson(reader);
                } else if ("supportsHibernation".equals(fieldName)) {
                    deserializedSnapshotProperties.supportsHibernation = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSnapshotProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("completionPercent".equals(fieldName)) {
                    deserializedSnapshotProperties.completionPercent = reader.getNullable(JsonReader::getFloat);
                } else if ("copyCompletionError".equals(fieldName)) {
                    deserializedSnapshotProperties.copyCompletionError = CopyCompletionError.fromJson(reader);
                } else if ("dataAccessAuthMode".equals(fieldName)) {
                    deserializedSnapshotProperties.dataAccessAuthMode
                        = DataAccessAuthMode.fromString(reader.getString());
                } else if ("snapshotAccessState".equals(fieldName)) {
                    deserializedSnapshotProperties.snapshotAccessState
                        = SnapshotAccessState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSnapshotProperties;
        });
    }
}
