// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SoftDeletedArtifactTypes;
import java.io.IOException;
import java.util.Map;

/**
 * The details information of soft-deleted resource.
 */
@Fluent
public final class GallerySoftDeletedResourceInner extends Resource {
    /*
     * Describes the properties of a soft-deleted resource.
     */
    private GallerySoftDeletedResourceProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GallerySoftDeletedResourceInner class.
     */
    public GallerySoftDeletedResourceInner() {
    }

    /**
     * Get the innerProperties property: Describes the properties of a soft-deleted resource.
     * 
     * @return the innerProperties value.
     */
    private GallerySoftDeletedResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GallerySoftDeletedResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GallerySoftDeletedResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resourceArmId property: arm id of the soft-deleted resource.
     * 
     * @return the resourceArmId value.
     */
    public String resourceArmId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceArmId();
    }

    /**
     * Set the resourceArmId property: arm id of the soft-deleted resource.
     * 
     * @param resourceArmId the resourceArmId value to set.
     * @return the GallerySoftDeletedResourceInner object itself.
     */
    public GallerySoftDeletedResourceInner withResourceArmId(String resourceArmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withResourceArmId(resourceArmId);
        return this;
    }

    /**
     * Get the softDeletedArtifactType property: artifact type of the soft-deleted resource.
     * 
     * @return the softDeletedArtifactType value.
     */
    public SoftDeletedArtifactTypes softDeletedArtifactType() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletedArtifactType();
    }

    /**
     * Set the softDeletedArtifactType property: artifact type of the soft-deleted resource.
     * 
     * @param softDeletedArtifactType the softDeletedArtifactType value to set.
     * @return the GallerySoftDeletedResourceInner object itself.
     */
    public GallerySoftDeletedResourceInner
        withSoftDeletedArtifactType(SoftDeletedArtifactTypes softDeletedArtifactType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withSoftDeletedArtifactType(softDeletedArtifactType);
        return this;
    }

    /**
     * Get the softDeletedTime property: The timestamp for when the resource is soft-deleted. In dateTime offset format.
     * 
     * @return the softDeletedTime value.
     */
    public String softDeletedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletedTime();
    }

    /**
     * Set the softDeletedTime property: The timestamp for when the resource is soft-deleted. In dateTime offset format.
     * 
     * @param softDeletedTime the softDeletedTime value to set.
     * @return the GallerySoftDeletedResourceInner object itself.
     */
    public GallerySoftDeletedResourceInner withSoftDeletedTime(String softDeletedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withSoftDeletedTime(softDeletedTime);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GallerySoftDeletedResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GallerySoftDeletedResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GallerySoftDeletedResourceInner.
     */
    public static GallerySoftDeletedResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GallerySoftDeletedResourceInner deserializedGallerySoftDeletedResourceInner
                = new GallerySoftDeletedResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGallerySoftDeletedResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.innerProperties
                        = GallerySoftDeletedResourceProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGallerySoftDeletedResourceInner;
        });
    }
}
