// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationCustomAction;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Describes the properties of a gallery Application Definition.
 */
@Fluent
public final class GalleryApplicationProperties implements JsonSerializable<GalleryApplicationProperties> {
    /*
     * The description of this gallery Application Definition resource. This property is updatable.
     */
    private String description;

    /*
     * The Eula agreement for the gallery Application Definition.
     */
    private String eula;

    /*
     * The privacy statement uri.
     */
    private String privacyStatementUri;

    /*
     * The release note uri.
     */
    private String releaseNoteUri;

    /*
     * The end of life date of the gallery Application Definition. This property can be used for decommissioning
     * purposes. This property is updatable.
     */
    private OffsetDateTime endOfLifeDate;

    /*
     * This property allows you to specify the supported type of the OS that application is built for. Possible values
     * are: **Windows,** **Linux.**
     */
    private OperatingSystemTypes supportedOSType;

    /*
     * A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery
     * Application.
     */
    private List<GalleryApplicationCustomAction> customActions;

    /**
     * Creates an instance of GalleryApplicationProperties class.
     */
    public GalleryApplicationProperties() {
    }

    /**
     * Get the description property: The description of this gallery Application Definition resource. This property is
     * updatable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of this gallery Application Definition resource. This property is
     * updatable.
     * 
     * @param description the description value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the eula property: The Eula agreement for the gallery Application Definition.
     * 
     * @return the eula value.
     */
    public String eula() {
        return this.eula;
    }

    /**
     * Set the eula property: The Eula agreement for the gallery Application Definition.
     * 
     * @param eula the eula value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    /**
     * Get the privacyStatementUri property: The privacy statement uri.
     * 
     * @return the privacyStatementUri value.
     */
    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    /**
     * Set the privacyStatementUri property: The privacy statement uri.
     * 
     * @param privacyStatementUri the privacyStatementUri value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    /**
     * Get the releaseNoteUri property: The release note uri.
     * 
     * @return the releaseNoteUri value.
     */
    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    /**
     * Set the releaseNoteUri property: The release note uri.
     * 
     * @param releaseNoteUri the releaseNoteUri value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    /**
     * Get the endOfLifeDate property: The end of life date of the gallery Application Definition. This property can be
     * used for decommissioning purposes. This property is updatable.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Set the endOfLifeDate property: The end of life date of the gallery Application Definition. This property can be
     * used for decommissioning purposes. This property is updatable.
     * 
     * @param endOfLifeDate the endOfLifeDate value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    /**
     * Get the supportedOSType property: This property allows you to specify the supported type of the OS that
     * application is built for. Possible values are: **Windows,** **Linux.**.
     * 
     * @return the supportedOSType value.
     */
    public OperatingSystemTypes supportedOSType() {
        return this.supportedOSType;
    }

    /**
     * Set the supportedOSType property: This property allows you to specify the supported type of the OS that
     * application is built for. Possible values are: **Windows,** **Linux.**.
     * 
     * @param supportedOSType the supportedOSType value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withSupportedOSType(OperatingSystemTypes supportedOSType) {
        this.supportedOSType = supportedOSType;
        return this;
    }

    /**
     * Get the customActions property: A list of custom actions that can be performed with all of the Gallery
     * Application Versions within this Gallery Application.
     * 
     * @return the customActions value.
     */
    public List<GalleryApplicationCustomAction> customActions() {
        return this.customActions;
    }

    /**
     * Set the customActions property: A list of custom actions that can be performed with all of the Gallery
     * Application Versions within this Gallery Application.
     * 
     * @param customActions the customActions value to set.
     * @return the GalleryApplicationProperties object itself.
     */
    public GalleryApplicationProperties withCustomActions(List<GalleryApplicationCustomAction> customActions) {
        this.customActions = customActions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedOSType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property supportedOSType in model GalleryApplicationProperties"));
        }
        if (customActions() != null) {
            customActions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("supportedOSType",
            this.supportedOSType == null ? null : this.supportedOSType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("releaseNoteUri", this.releaseNoteUri);
        jsonWriter.writeStringField("endOfLifeDate",
            this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeArrayField("customActions", this.customActions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryApplicationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryApplicationProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryApplicationProperties.
     */
    public static GalleryApplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationProperties deserializedGalleryApplicationProperties = new GalleryApplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("supportedOSType".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.supportedOSType
                        = OperatingSystemTypes.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.description = reader.getString();
                } else if ("eula".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.eula = reader.getString();
                } else if ("privacyStatementUri".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.privacyStatementUri = reader.getString();
                } else if ("releaseNoteUri".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.releaseNoteUri = reader.getString();
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryApplicationProperties.endOfLifeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("customActions".equals(fieldName)) {
                    List<GalleryApplicationCustomAction> customActions
                        = reader.readArray(reader1 -> GalleryApplicationCustomAction.fromJson(reader1));
                    deserializedGalleryApplicationProperties.customActions = customActions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryApplicationProperties;
        });
    }
}
