// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a
 * dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be
 * added to another dedicated host group.
 */
@Fluent
public final class DedicatedHostGroupInner extends Resource {
    /*
     * Dedicated Host Group Properties.
     */
    private DedicatedHostGroupProperties innerProperties;

    /*
     * The availability zones.
     */
    private List<String> zones;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DedicatedHostGroupInner class.
     */
    public DedicatedHostGroupInner() {
    }

    /**
     * Get the innerProperties property: Dedicated Host Group Properties.
     * 
     * @return the innerProperties value.
     */
    private DedicatedHostGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the zones property: The availability zones.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: The availability zones.
     * 
     * @param zones the zones value to set.
     * @return the DedicatedHostGroupInner object itself.
     */
    public DedicatedHostGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the platformFaultDomainCount property: Number of fault domains that the host group can span.
     * 
     * @return the platformFaultDomainCount value.
     */
    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    /**
     * Set the platformFaultDomainCount property: Number of fault domains that the host group can span.
     * 
     * @param platformFaultDomainCount the platformFaultDomainCount value to set.
     * @return the DedicatedHostGroupInner object itself.
     */
    public DedicatedHostGroupInner withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    /**
     * Get the hosts property: A list of references to all dedicated hosts in the dedicated host group.
     * 
     * @return the hosts value.
     */
    public List<SubResourceReadOnly> hosts() {
        return this.innerProperties() == null ? null : this.innerProperties().hosts();
    }

    /**
     * Get the instanceView property: The dedicated host group instance view, which has the list of instance view of the
     * dedicated hosts under the dedicated host group.
     * 
     * @return the instanceView value.
     */
    public DedicatedHostGroupInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the supportAutomaticPlacement property: Specifies whether virtual machines or virtual machine scale sets can
     * be placed automatically on the dedicated host group. Automatic placement means resources are allocated on
     * dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when
     * not provided. Minimum api-version: 2020-06-01.
     * 
     * @return the supportAutomaticPlacement value.
     */
    public Boolean supportAutomaticPlacement() {
        return this.innerProperties() == null ? null : this.innerProperties().supportAutomaticPlacement();
    }

    /**
     * Set the supportAutomaticPlacement property: Specifies whether virtual machines or virtual machine scale sets can
     * be placed automatically on the dedicated host group. Automatic placement means resources are allocated on
     * dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when
     * not provided. Minimum api-version: 2020-06-01.
     * 
     * @param supportAutomaticPlacement the supportAutomaticPlacement value to set.
     * @return the DedicatedHostGroupInner object itself.
     */
    public DedicatedHostGroupInner withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withSupportAutomaticPlacement(supportAutomaticPlacement);
        return this;
    }

    /**
     * Get the additionalCapabilities property: Enables or disables a capability on the dedicated host group. Minimum
     * api-version: 2022-03-01.
     * 
     * @return the additionalCapabilities value.
     */
    public DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    /**
     * Set the additionalCapabilities property: Enables or disables a capability on the dedicated host group. Minimum
     * api-version: 2022-03-01.
     * 
     * @param additionalCapabilities the additionalCapabilities value to set.
     * @return the DedicatedHostGroupInner object itself.
     */
    public DedicatedHostGroupInner
        withAdditionalCapabilities(DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostGroupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostGroupInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DedicatedHostGroupInner.
     */
    public static DedicatedHostGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostGroupInner deserializedDedicatedHostGroupInner = new DedicatedHostGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHostGroupInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.innerProperties = DedicatedHostGroupProperties.fromJson(reader);
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedDedicatedHostGroupInner.zones = zones;
                } else if ("systemData".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostGroupInner;
        });
    }
}
