// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ScheduledEventsPolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetMigrationInfo;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of a resource.
 */
@Fluent
public final class AvailabilitySetProperties implements JsonSerializable<AvailabilitySetProperties> {
    /*
     * Update Domain count.
     */
    private Integer platformUpdateDomainCount;

    /*
     * Fault Domain count.
     */
    private Integer platformFaultDomainCount;

    /*
     * A list of references to all virtual machines in the availability set.
     */
    private List<SubResource> virtualMachines;

    /*
     * Specifies information about the proximity placement group that the availability set should be assigned to.
     * Minimum api-version: 2018-04-01.
     */
    private SubResource proximityPlacementGroup;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> statuses;

    /*
     * Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets Scheduled Event related configurations
     * for the availability set.
     */
    private ScheduledEventsPolicy scheduledEventsPolicy;

    /*
     * Describes the migration properties on the Availability Set.
     */
    private VirtualMachineScaleSetMigrationInfo virtualMachineScaleSetMigrationInfo;

    /**
     * Creates an instance of AvailabilitySetProperties class.
     */
    public AvailabilitySetProperties() {
    }

    /**
     * Get the platformUpdateDomainCount property: Update Domain count.
     * 
     * @return the platformUpdateDomainCount value.
     */
    public Integer platformUpdateDomainCount() {
        return this.platformUpdateDomainCount;
    }

    /**
     * Set the platformUpdateDomainCount property: Update Domain count.
     * 
     * @param platformUpdateDomainCount the platformUpdateDomainCount value to set.
     * @return the AvailabilitySetProperties object itself.
     */
    public AvailabilitySetProperties withPlatformUpdateDomainCount(Integer platformUpdateDomainCount) {
        this.platformUpdateDomainCount = platformUpdateDomainCount;
        return this;
    }

    /**
     * Get the platformFaultDomainCount property: Fault Domain count.
     * 
     * @return the platformFaultDomainCount value.
     */
    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    /**
     * Set the platformFaultDomainCount property: Fault Domain count.
     * 
     * @param platformFaultDomainCount the platformFaultDomainCount value to set.
     * @return the AvailabilitySetProperties object itself.
     */
    public AvailabilitySetProperties withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    /**
     * Get the virtualMachines property: A list of references to all virtual machines in the availability set.
     * 
     * @return the virtualMachines value.
     */
    public List<SubResource> virtualMachines() {
        return this.virtualMachines;
    }

    /**
     * Set the virtualMachines property: A list of references to all virtual machines in the availability set.
     * 
     * @param virtualMachines the virtualMachines value to set.
     * @return the AvailabilitySetProperties object itself.
     */
    public AvailabilitySetProperties withVirtualMachines(List<SubResource> virtualMachines) {
        this.virtualMachines = virtualMachines;
        return this;
    }

    /**
     * Get the proximityPlacementGroup property: Specifies information about the proximity placement group that the
     * availability set should be assigned to. Minimum api-version: 2018-04-01.
     * 
     * @return the proximityPlacementGroup value.
     */
    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    /**
     * Set the proximityPlacementGroup property: Specifies information about the proximity placement group that the
     * availability set should be assigned to. Minimum api-version: 2018-04-01.
     * 
     * @param proximityPlacementGroup the proximityPlacementGroup value to set.
     * @return the AvailabilitySetProperties object itself.
     */
    public AvailabilitySetProperties withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Get the scheduledEventsPolicy property: Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets
     * Scheduled Event related configurations for the availability set.
     * 
     * @return the scheduledEventsPolicy value.
     */
    public ScheduledEventsPolicy scheduledEventsPolicy() {
        return this.scheduledEventsPolicy;
    }

    /**
     * Set the scheduledEventsPolicy property: Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets
     * Scheduled Event related configurations for the availability set.
     * 
     * @param scheduledEventsPolicy the scheduledEventsPolicy value to set.
     * @return the AvailabilitySetProperties object itself.
     */
    public AvailabilitySetProperties withScheduledEventsPolicy(ScheduledEventsPolicy scheduledEventsPolicy) {
        this.scheduledEventsPolicy = scheduledEventsPolicy;
        return this;
    }

    /**
     * Get the virtualMachineScaleSetMigrationInfo property: Describes the migration properties on the Availability Set.
     * 
     * @return the virtualMachineScaleSetMigrationInfo value.
     */
    public VirtualMachineScaleSetMigrationInfo virtualMachineScaleSetMigrationInfo() {
        return this.virtualMachineScaleSetMigrationInfo;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
        if (scheduledEventsPolicy() != null) {
            scheduledEventsPolicy().validate();
        }
        if (virtualMachineScaleSetMigrationInfo() != null) {
            virtualMachineScaleSetMigrationInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("platformUpdateDomainCount", this.platformUpdateDomainCount);
        jsonWriter.writeNumberField("platformFaultDomainCount", this.platformFaultDomainCount);
        jsonWriter.writeArrayField("virtualMachines", this.virtualMachines,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("proximityPlacementGroup", this.proximityPlacementGroup);
        jsonWriter.writeJsonField("scheduledEventsPolicy", this.scheduledEventsPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailabilitySetProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailabilitySetProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailabilitySetProperties.
     */
    public static AvailabilitySetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailabilitySetProperties deserializedAvailabilitySetProperties = new AvailabilitySetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("platformUpdateDomainCount".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.platformUpdateDomainCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("platformFaultDomainCount".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.platformFaultDomainCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("virtualMachines".equals(fieldName)) {
                    List<SubResource> virtualMachines = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedAvailabilitySetProperties.virtualMachines = virtualMachines;
                } else if ("proximityPlacementGroup".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.proximityPlacementGroup = SubResource.fromJson(reader);
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedAvailabilitySetProperties.statuses = statuses;
                } else if ("scheduledEventsPolicy".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.scheduledEventsPolicy
                        = ScheduledEventsPolicy.fromJson(reader);
                } else if ("virtualMachineScaleSetMigrationInfo".equals(fieldName)) {
                    deserializedAvailabilitySetProperties.virtualMachineScaleSetMigrationInfo
                        = VirtualMachineScaleSetMigrationInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailabilitySetProperties;
        });
    }
}
