/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.azure.resourcemanager.compute.models.DiskRestorePointAttributes;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.azure.resourcemanager.compute.models.OperatingSystemType;
import java.io.IOException;

public final class RestorePointSourceVmosDisk
implements JsonSerializable<RestorePointSourceVmosDisk> {
    private OperatingSystemType osType;
    private DiskEncryptionSettings encryptionSettings;
    private String name;
    private CachingTypes caching;
    private Integer diskSizeGB;
    private ManagedDiskParameters managedDisk;
    private DiskRestorePointAttributes diskRestorePoint;
    private Boolean writeAcceleratorEnabled;

    public OperatingSystemType osType() {
        return this.osType;
    }

    public DiskEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public String name() {
        return this.name;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public RestorePointSourceVmosDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskRestorePointAttributes diskRestorePoint() {
        return this.diskRestorePoint;
    }

    public RestorePointSourceVmosDisk withDiskRestorePoint(DiskRestorePointAttributes diskRestorePoint) {
        this.diskRestorePoint = diskRestorePoint;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
        if (this.diskRestorePoint() != null) {
            this.diskRestorePoint().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeJsonField("diskRestorePoint", (JsonSerializable)this.diskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointSourceVmosDisk fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointSourceVmosDisk)jsonReader.readObject(reader -> {
            RestorePointSourceVmosDisk deserializedRestorePointSourceVmosDisk = new RestorePointSourceVmosDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.osType = OperatingSystemType.fromString(reader.getString());
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.encryptionSettings = DiskEncryptionSettings.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.name = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("diskRestorePoint".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.diskRestorePoint = DiskRestorePointAttributes.fromJson(reader);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointSourceVmosDisk;
        });
    }
}

