/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.PatchOperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LastPatchInstallationSummary
implements JsonSerializable<LastPatchInstallationSummary> {
    private PatchOperationStatus status;
    private String installationActivityId;
    private Boolean maintenanceWindowExceeded;
    private Integer notSelectedPatchCount;
    private Integer excludedPatchCount;
    private Integer pendingPatchCount;
    private Integer installedPatchCount;
    private Integer failedPatchCount;
    private OffsetDateTime startTime;
    private OffsetDateTime lastModifiedTime;
    private ApiError error;

    public PatchOperationStatus status() {
        return this.status;
    }

    public String installationActivityId() {
        return this.installationActivityId;
    }

    public Boolean maintenanceWindowExceeded() {
        return this.maintenanceWindowExceeded;
    }

    public Integer notSelectedPatchCount() {
        return this.notSelectedPatchCount;
    }

    public Integer excludedPatchCount() {
        return this.excludedPatchCount;
    }

    public Integer pendingPatchCount() {
        return this.pendingPatchCount;
    }

    public Integer installedPatchCount() {
        return this.installedPatchCount;
    }

    public Integer failedPatchCount() {
        return this.failedPatchCount;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ApiError error() {
        return this.error;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static LastPatchInstallationSummary fromJson(JsonReader jsonReader) throws IOException {
        return (LastPatchInstallationSummary)jsonReader.readObject(reader -> {
            LastPatchInstallationSummary deserializedLastPatchInstallationSummary = new LastPatchInstallationSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.status = PatchOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("installationActivityId".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.installationActivityId = reader.getString();
                    continue;
                }
                if ("maintenanceWindowExceeded".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.maintenanceWindowExceeded = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("notSelectedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.notSelectedPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("excludedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.excludedPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("pendingPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.pendingPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("installedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.installedPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.failedPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.error = ApiError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLastPatchInstallationSummary;
        });
    }
}

