/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionProperties;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import java.io.IOException;
import java.util.Map;

public final class GalleryApplicationVersionUpdate
extends UpdateResourceDefinition {
    private GalleryApplicationVersionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private GalleryApplicationVersionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GalleryApplicationVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public GalleryApplicationVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    public GalleryApplicationVersionUpdate withPublishingProfile(GalleryApplicationVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    public GalleryApplicationVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    public GalleryApplicationVersionUpdate withSafetyProfile(GalleryApplicationVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationVersionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryApplicationVersionUpdate)jsonReader.readObject(reader -> {
            GalleryApplicationVersionUpdate deserializedGalleryApplicationVersionUpdate = new GalleryApplicationVersionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryApplicationVersionUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.innerProperties = GalleryApplicationVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationVersionUpdate;
        });
    }
}

