/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class VirtualMachineImageImpl
extends IndexableWrapperImpl<VirtualMachineImageInner>
implements VirtualMachineImage {
    private final Region location;
    private ImageReference imageReference;

    VirtualMachineImageImpl(Region location, String publisher, String offer, String sku, String version) {
        super(null);
        this.location = location;
        this.imageReference = new ImageReference();
        this.imageReference.withPublisher(publisher);
        this.imageReference.withOffer(offer);
        this.imageReference.withSku(sku);
        this.imageReference.withVersion(version);
    }

    VirtualMachineImageImpl(Region location, String publisher, String offer, String sku, String version, VirtualMachineImageInner innerModel) {
        super((Object)innerModel);
        this.location = location;
        this.imageReference = new ImageReference();
        this.imageReference.withPublisher(publisher);
        this.imageReference.withOffer(offer);
        this.imageReference.withSku(sku);
        this.imageReference.withVersion(version);
    }

    @Override
    public String id() {
        if (this.innerModel() == null) {
            return null;
        }
        return ((VirtualMachineImageInner)((Object)this.innerModel())).id();
    }

    @Override
    public Region location() {
        return this.location;
    }

    @Override
    public String publisherName() {
        return this.imageReference.publisher();
    }

    @Override
    public String offer() {
        return this.imageReference.offer();
    }

    @Override
    public String sku() {
        return this.imageReference.sku();
    }

    @Override
    public String version() {
        return this.imageReference.version();
    }

    @Override
    public ImageReference imageReference() {
        return this.imageReference;
    }

    @Override
    public PurchasePlan plan() {
        return ((VirtualMachineImageInner)((Object)this.innerModel())).plan();
    }

    @Override
    public OSDiskImage osDiskImage() {
        return ((VirtualMachineImageInner)((Object)this.innerModel())).osDiskImage();
    }

    @Override
    public Map<Integer, DataDiskImage> dataDiskImages() {
        if (((VirtualMachineImageInner)((Object)this.innerModel())).dataDiskImages() == null) {
            return Collections.unmodifiableMap(new HashMap());
        }
        HashMap<Integer, DataDiskImage> diskImages = new HashMap<Integer, DataDiskImage>();
        for (DataDiskImage diskImage : ((VirtualMachineImageInner)((Object)this.innerModel())).dataDiskImages()) {
            diskImages.put(diskImage.lun(), diskImage);
        }
        return Collections.unmodifiableMap(diskImages);
    }
}

