/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class ResourceWithOptionalLocation
extends Resource {
    private String type;
    private String name;
    private String id;

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ResourceWithOptionalLocation withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ResourceWithOptionalLocation withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceWithOptionalLocation fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceWithOptionalLocation)((Object)jsonReader.readObject(reader -> {
            ResourceWithOptionalLocation deserializedResourceWithOptionalLocation = new ResourceWithOptionalLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceWithOptionalLocation.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceWithOptionalLocation.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceWithOptionalLocation.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceWithOptionalLocation.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedResourceWithOptionalLocation.withTags(tags);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceWithOptionalLocation;
        }));
    }
}

