// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies additional capabilities supported by the image.
 */
@Fluent
public final class VirtualMachineImageFeature implements JsonSerializable<VirtualMachineImageFeature> {
    /*
     * The name of the feature.
     */
    private String name;

    /*
     * The corresponding value for the feature.
     */
    private String value;

    /**
     * Creates an instance of VirtualMachineImageFeature class.
     */
    public VirtualMachineImageFeature() {
    }

    /**
     * Get the name property: The name of the feature.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the feature.
     * 
     * @param name the name value to set.
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The corresponding value for the feature.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The corresponding value for the feature.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineImageFeature from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineImageFeature if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineImageFeature.
     */
    public static VirtualMachineImageFeature fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineImageFeature deserializedVirtualMachineImageFeature = new VirtualMachineImageFeature();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineImageFeature.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedVirtualMachineImageFeature.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineImageFeature;
        });
    }
}
