// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A UEFI key signature.
 */
@Fluent
public final class UefiKey implements JsonSerializable<UefiKey> {
    /*
     * The type of key signature.
     */
    private UefiKeyType type;

    /*
     * The value of the key signature.
     */
    private List<String> value;

    /**
     * Creates an instance of UefiKey class.
     */
    public UefiKey() {
    }

    /**
     * Get the type property: The type of key signature.
     * 
     * @return the type value.
     */
    public UefiKeyType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of key signature.
     * 
     * @param type the type value to set.
     * @return the UefiKey object itself.
     */
    public UefiKey withType(UefiKeyType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: The value of the key signature.
     * 
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the key signature.
     * 
     * @param value the value value to set.
     * @return the UefiKey object itself.
     */
    public UefiKey withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UefiKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UefiKey if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the UefiKey.
     */
    public static UefiKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UefiKey deserializedUefiKey = new UefiKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedUefiKey.type = UefiKeyType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    List<String> value = reader.readArray(reader1 -> reader1.getString());
                    deserializedUefiKey.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUefiKey;
        });
    }
}
