// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the hardware settings for the virtual machine.
 */
@Fluent
public final class HardwareProfile implements JsonSerializable<HardwareProfile> {
    /*
     * Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by
     * December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all
     * available virtual machine sizes in an availability
     * set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes), [List all available
     * virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list), [List all
     * available virtual machine sizes for
     * resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information
     * about virtual machine sizes, see [Sizes for virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and
     * availability set.
     */
    private VirtualMachineSizeTypes vmSize;

    /*
     * Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This
     * feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions
     * in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    private VMSizeProperties vmSizeProperties;

    /**
     * Creates an instance of HardwareProfile class.
     */
    public HardwareProfile() {
    }

    /**
     * Get the vmSize property: Specifies the size of the virtual machine. The enum data type is currently deprecated
     * and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these
     * APIs: [List all available virtual machine sizes in an availability
     * set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes), [List all available
     * virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list), [List all
     * available virtual machine sizes for
     * resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information
     * about virtual machine sizes, see [Sizes for virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and
     * availability set.
     * 
     * @return the vmSize value.
     */
    public VirtualMachineSizeTypes vmSize() {
        return this.vmSize;
    }

    /**
     * Set the vmSize property: Specifies the size of the virtual machine. The enum data type is currently deprecated
     * and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these
     * APIs: [List all available virtual machine sizes in an availability
     * set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes), [List all available
     * virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list), [List all
     * available virtual machine sizes for
     * resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information
     * about virtual machine sizes, see [Sizes for virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and
     * availability set.
     * 
     * @param vmSize the vmSize value to set.
     * @return the HardwareProfile object itself.
     */
    public HardwareProfile withVmSize(VirtualMachineSizeTypes vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get the vmSizeProperties property: Specifies the properties for customizing the size of the virtual machine.
     * Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for
     * VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for
     * more details.
     * 
     * @return the vmSizeProperties value.
     */
    public VMSizeProperties vmSizeProperties() {
        return this.vmSizeProperties;
    }

    /**
     * Set the vmSizeProperties property: Specifies the properties for customizing the size of the virtual machine.
     * Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for
     * VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for
     * more details.
     * 
     * @param vmSizeProperties the vmSizeProperties value to set.
     * @return the HardwareProfile object itself.
     */
    public HardwareProfile withVmSizeProperties(VMSizeProperties vmSizeProperties) {
        this.vmSizeProperties = vmSizeProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vmSizeProperties() != null) {
            vmSizeProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeJsonField("vmSizeProperties", this.vmSizeProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HardwareProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HardwareProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HardwareProfile.
     */
    public static HardwareProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HardwareProfile deserializedHardwareProfile = new HardwareProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmSize".equals(fieldName)) {
                    deserializedHardwareProfile.vmSize = VirtualMachineSizeTypes.fromString(reader.getString());
                } else if ("vmSizeProperties".equals(fieldName)) {
                    deserializedHardwareProfile.vmSizeProperties = VMSizeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHardwareProfile;
        });
    }
}
