// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.compute.fluent.SoftDeletedResourcesClient;
import com.azure.resourcemanager.compute.fluent.models.GallerySoftDeletedResourceInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GallerySoftDeletedResourceList;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in SoftDeletedResourcesClient.
 */
public final class SoftDeletedResourcesClientImpl implements SoftDeletedResourcesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final SoftDeletedResourcesService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of SoftDeletedResourcesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    SoftDeletedResourcesClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(SoftDeletedResourcesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientSoftDeletedResources to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    public interface SoftDeletedResourcesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/softDeletedArtifactTypes/{artifactType}/artifacts/{artifactName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GallerySoftDeletedResourceList>> listByArtifactName(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("artifactType") String artifactType, @PathParam("artifactName") String artifactName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GallerySoftDeletedResourceList>> listByArtifactNameNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameSinglePageAsync(
        String resourceGroupName, String galleryName, String artifactType, String artifactName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (artifactType == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactType is required and cannot be null."));
        }
        if (artifactName == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByArtifactName(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, galleryName, artifactType, artifactName, apiVersion, accept, context))
            .<PagedResponse<GallerySoftDeletedResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameSinglePageAsync(
        String resourceGroupName, String galleryName, String artifactType, String artifactName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (artifactType == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactType is required and cannot be null."));
        }
        if (artifactName == null) {
            return Mono.error(new IllegalArgumentException("Parameter artifactName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByArtifactName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                galleryName, artifactType, artifactName, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GallerySoftDeletedResourceInner> listByArtifactNameAsync(String resourceGroupName,
        String galleryName, String artifactType, String artifactName) {
        return new PagedFlux<>(
            () -> listByArtifactNameSinglePageAsync(resourceGroupName, galleryName, artifactType, artifactName),
            nextLink -> listByArtifactNameNextSinglePageAsync(nextLink));
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GallerySoftDeletedResourceInner> listByArtifactNameAsync(String resourceGroupName,
        String galleryName, String artifactType, String artifactName, Context context) {
        return new PagedFlux<>(() -> listByArtifactNameSinglePageAsync(resourceGroupName, galleryName, artifactType,
            artifactName, context), nextLink -> listByArtifactNameNextSinglePageAsync(nextLink, context));
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GallerySoftDeletedResourceInner> listByArtifactName(String resourceGroupName,
        String galleryName, String artifactType, String artifactName) {
        return new PagedIterable<>(listByArtifactNameAsync(resourceGroupName, galleryName, artifactType, artifactName));
    }

    /**
     * List soft-deleted resources of an artifact in the gallery, such as soft-deleted gallery image version of an
     * image.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Gallery in which the soft-deleted resources resides.
     * @param artifactType The type of the artifact to be listed, such as gallery image version.
     * @param artifactName The artifact name to be listed. If artifact type is Images, then the artifact name should be
     * the gallery image name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GallerySoftDeletedResourceInner> listByArtifactName(String resourceGroupName,
        String galleryName, String artifactType, String artifactName, Context context) {
        return new PagedIterable<>(
            listByArtifactNameAsync(resourceGroupName, galleryName, artifactType, artifactName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>>
        listByArtifactNameNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByArtifactNameNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GallerySoftDeletedResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Soft-deleted Resources operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GallerySoftDeletedResourceInner>> listByArtifactNameNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByArtifactNameNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
