/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetScaleInRules;
import java.io.IOException;
import java.util.List;

public final class ScaleInPolicy
implements JsonSerializable<ScaleInPolicy> {
    private List<VirtualMachineScaleSetScaleInRules> rules;
    private Boolean forceDeletion;
    private Boolean prioritizeUnhealthyVMs;

    public List<VirtualMachineScaleSetScaleInRules> rules() {
        return this.rules;
    }

    public ScaleInPolicy withRules(List<VirtualMachineScaleSetScaleInRules> rules) {
        this.rules = rules;
        return this;
    }

    public Boolean forceDeletion() {
        return this.forceDeletion;
    }

    public ScaleInPolicy withForceDeletion(Boolean forceDeletion) {
        this.forceDeletion = forceDeletion;
        return this;
    }

    public Boolean prioritizeUnhealthyVMs() {
        return this.prioritizeUnhealthyVMs;
    }

    public ScaleInPolicy withPrioritizeUnhealthyVMs(Boolean prioritizeUnhealthyVMs) {
        this.prioritizeUnhealthyVMs = prioritizeUnhealthyVMs;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("forceDeletion", this.forceDeletion);
        jsonWriter.writeBooleanField("prioritizeUnhealthyVMs", this.prioritizeUnhealthyVMs);
        return jsonWriter.writeEndObject();
    }

    public static ScaleInPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ScaleInPolicy)jsonReader.readObject(reader -> {
            ScaleInPolicy deserializedScaleInPolicy = new ScaleInPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedScaleInPolicy.rules = rules = reader.readArray(reader1 -> VirtualMachineScaleSetScaleInRules.fromString(reader1.getString()));
                    continue;
                }
                if ("forceDeletion".equals(fieldName)) {
                    deserializedScaleInPolicy.forceDeletion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("prioritizeUnhealthyVMs".equals(fieldName)) {
                    deserializedScaleInPolicy.prioritizeUnhealthyVMs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleInPolicy;
        });
    }
}

