/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetSkuInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetListSkusResult
implements JsonSerializable<VirtualMachineScaleSetListSkusResult> {
    private List<VirtualMachineScaleSetSkuInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetListSkusResult.class);

    public List<VirtualMachineScaleSetSkuInner> value() {
        return this.value;
    }

    public VirtualMachineScaleSetListSkusResult withValue(List<VirtualMachineScaleSetSkuInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualMachineScaleSetListSkusResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model VirtualMachineScaleSetListSkusResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetListSkusResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetListSkusResult)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetListSkusResult deserializedVirtualMachineScaleSetListSkusResult = new VirtualMachineScaleSetListSkusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineScaleSetListSkusResult.value = value = reader.readArray(reader1 -> VirtualMachineScaleSetSkuInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetListSkusResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetListSkusResult;
        });
    }
}

