/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SharedGalleryDataDiskImage;
import com.azure.resourcemanager.compute.models.SharedGalleryOSDiskImage;
import java.io.IOException;
import java.util.List;

public final class SharedGalleryImageVersionStorageProfile
implements JsonSerializable<SharedGalleryImageVersionStorageProfile> {
    private SharedGalleryOSDiskImage osDiskImage;
    private List<SharedGalleryDataDiskImage> dataDiskImages;

    public SharedGalleryOSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public SharedGalleryImageVersionStorageProfile withOsDiskImage(SharedGalleryOSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<SharedGalleryDataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public SharedGalleryImageVersionStorageProfile withDataDiskImages(List<SharedGalleryDataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public void validate() {
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDiskImage", (JsonSerializable)this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryImageVersionStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SharedGalleryImageVersionStorageProfile)jsonReader.readObject(reader -> {
            SharedGalleryImageVersionStorageProfile deserializedSharedGalleryImageVersionStorageProfile = new SharedGalleryImageVersionStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osDiskImage".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionStorageProfile.osDiskImage = SharedGalleryOSDiskImage.fromJson(reader);
                    continue;
                }
                if ("dataDiskImages".equals(fieldName)) {
                    List dataDiskImages;
                    deserializedSharedGalleryImageVersionStorageProfile.dataDiskImages = dataDiskImages = reader.readArray(reader1 -> SharedGalleryDataDiskImage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryImageVersionStorageProfile;
        });
    }
}

