/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskRestorePointAttributes;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import java.io.IOException;

public final class RestorePointSourceVMDataDisk
implements JsonSerializable<RestorePointSourceVMDataDisk> {
    private Integer lun;
    private String name;
    private CachingTypes caching;
    private Integer diskSizeGB;
    private ManagedDiskParameters managedDisk;
    private DiskRestorePointAttributes diskRestorePoint;
    private Boolean writeAcceleratorEnabled;

    public Integer lun() {
        return this.lun;
    }

    public String name() {
        return this.name;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public RestorePointSourceVMDataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskRestorePointAttributes diskRestorePoint() {
        return this.diskRestorePoint;
    }

    public RestorePointSourceVMDataDisk withDiskRestorePoint(DiskRestorePointAttributes diskRestorePoint) {
        this.diskRestorePoint = diskRestorePoint;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public void validate() {
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
        if (this.diskRestorePoint() != null) {
            this.diskRestorePoint().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeJsonField("diskRestorePoint", (JsonSerializable)this.diskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointSourceVMDataDisk fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointSourceVMDataDisk)jsonReader.readObject(reader -> {
            RestorePointSourceVMDataDisk deserializedRestorePointSourceVMDataDisk = new RestorePointSourceVMDataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.lun = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.name = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("diskRestorePoint".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.diskRestorePoint = DiskRestorePointAttributes.fromJson(reader);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointSourceVMDataDisk;
        });
    }
}

