/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OSVersionPropertiesBase;
import java.io.IOException;
import java.util.List;

public final class OSFamilyProperties
implements JsonSerializable<OSFamilyProperties> {
    private String name;
    private String label;
    private List<OSVersionPropertiesBase> versions;

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public List<OSVersionPropertiesBase> versions() {
        return this.versions;
    }

    public void validate() {
        if (this.versions() != null) {
            this.versions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static OSFamilyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OSFamilyProperties)jsonReader.readObject(reader -> {
            OSFamilyProperties deserializedOSFamilyProperties = new OSFamilyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOSFamilyProperties.name = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedOSFamilyProperties.label = reader.getString();
                    continue;
                }
                if ("versions".equals(fieldName)) {
                    List versions;
                    deserializedOSFamilyProperties.versions = versions = reader.readArray(reader1 -> OSVersionPropertiesBase.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSFamilyProperties;
        });
    }
}

