/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.ApplicationProfile;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.CapacityReservationProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.ScheduledEventsPolicy;
import com.azure.resourcemanager.compute.models.ScheduledEventsProfile;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class VirtualMachinePropertiesInner
implements JsonSerializable<VirtualMachinePropertiesInner> {
    private HardwareProfile hardwareProfile;
    private ScheduledEventsPolicy scheduledEventsPolicy;
    private StorageProfile storageProfile;
    private AdditionalCapabilities additionalCapabilities;
    private OSProfile osProfile;
    private NetworkProfile networkProfile;
    private SecurityProfile securityProfile;
    private DiagnosticsProfile diagnosticsProfile;
    private SubResource availabilitySet;
    private SubResource virtualMachineScaleSet;
    private SubResource proximityPlacementGroup;
    private VirtualMachinePriorityTypes priority;
    private VirtualMachineEvictionPolicyTypes evictionPolicy;
    private BillingProfile billingProfile;
    private SubResource host;
    private SubResource hostGroup;
    private String provisioningState;
    private VirtualMachineInstanceViewInner instanceView;
    private String licenseType;
    private String vmId;
    private String extensionsTimeBudget;
    private Integer platformFaultDomain;
    private ScheduledEventsProfile scheduledEventsProfile;
    private String userData;
    private CapacityReservationProfile capacityReservation;
    private ApplicationProfile applicationProfile;
    private OffsetDateTime timeCreated;

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachinePropertiesInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public ScheduledEventsPolicy scheduledEventsPolicy() {
        return this.scheduledEventsPolicy;
    }

    public VirtualMachinePropertiesInner withScheduledEventsPolicy(ScheduledEventsPolicy scheduledEventsPolicy) {
        this.scheduledEventsPolicy = scheduledEventsPolicy;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachinePropertiesInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachinePropertiesInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachinePropertiesInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachinePropertiesInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachinePropertiesInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachinePropertiesInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachinePropertiesInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public SubResource virtualMachineScaleSet() {
        return this.virtualMachineScaleSet;
    }

    public VirtualMachinePropertiesInner withVirtualMachineScaleSet(SubResource virtualMachineScaleSet) {
        this.virtualMachineScaleSet = virtualMachineScaleSet;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachinePropertiesInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.priority;
    }

    public VirtualMachinePropertiesInner withPriority(VirtualMachinePriorityTypes priority) {
        this.priority = priority;
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.evictionPolicy;
    }

    public VirtualMachinePropertiesInner withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BillingProfile billingProfile() {
        return this.billingProfile;
    }

    public VirtualMachinePropertiesInner withBillingProfile(BillingProfile billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    public SubResource host() {
        return this.host;
    }

    public VirtualMachinePropertiesInner withHost(SubResource host) {
        this.host = host;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachinePropertiesInner withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachinePropertiesInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public String extensionsTimeBudget() {
        return this.extensionsTimeBudget;
    }

    public VirtualMachinePropertiesInner withExtensionsTimeBudget(String extensionsTimeBudget) {
        this.extensionsTimeBudget = extensionsTimeBudget;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachinePropertiesInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.scheduledEventsProfile;
    }

    public VirtualMachinePropertiesInner withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        this.scheduledEventsProfile = scheduledEventsProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachinePropertiesInner withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public CapacityReservationProfile capacityReservation() {
        return this.capacityReservation;
    }

    public VirtualMachinePropertiesInner withCapacityReservation(CapacityReservationProfile capacityReservation) {
        this.capacityReservation = capacityReservation;
        return this;
    }

    public ApplicationProfile applicationProfile() {
        return this.applicationProfile;
    }

    public VirtualMachinePropertiesInner withApplicationProfile(ApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.scheduledEventsPolicy() != null) {
            this.scheduledEventsPolicy().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.billingProfile() != null) {
            this.billingProfile().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.scheduledEventsProfile() != null) {
            this.scheduledEventsProfile().validate();
        }
        if (this.capacityReservation() != null) {
            this.capacityReservation().validate();
        }
        if (this.applicationProfile() != null) {
            this.applicationProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeJsonField("scheduledEventsPolicy", (JsonSerializable)this.scheduledEventsPolicy);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("additionalCapabilities", (JsonSerializable)this.additionalCapabilities);
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("diagnosticsProfile", (JsonSerializable)this.diagnosticsProfile);
        jsonWriter.writeJsonField("availabilitySet", (JsonSerializable)this.availabilitySet);
        jsonWriter.writeJsonField("virtualMachineScaleSet", (JsonSerializable)this.virtualMachineScaleSet);
        jsonWriter.writeJsonField("proximityPlacementGroup", (JsonSerializable)this.proximityPlacementGroup);
        jsonWriter.writeStringField("priority", this.priority == null ? null : this.priority.toString());
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy == null ? null : this.evictionPolicy.toString());
        jsonWriter.writeJsonField("billingProfile", (JsonSerializable)this.billingProfile);
        jsonWriter.writeJsonField("host", (JsonSerializable)this.host);
        jsonWriter.writeJsonField("hostGroup", (JsonSerializable)this.hostGroup);
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeStringField("extensionsTimeBudget", this.extensionsTimeBudget);
        jsonWriter.writeNumberField("platformFaultDomain", (Number)this.platformFaultDomain);
        jsonWriter.writeJsonField("scheduledEventsProfile", (JsonSerializable)this.scheduledEventsProfile);
        jsonWriter.writeStringField("userData", this.userData);
        jsonWriter.writeJsonField("capacityReservation", (JsonSerializable)this.capacityReservation);
        jsonWriter.writeJsonField("applicationProfile", (JsonSerializable)this.applicationProfile);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachinePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachinePropertiesInner)jsonReader.readObject(reader -> {
            VirtualMachinePropertiesInner deserializedVirtualMachinePropertiesInner = new VirtualMachinePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.hardwareProfile = HardwareProfile.fromJson(reader);
                    continue;
                }
                if ("scheduledEventsPolicy".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.scheduledEventsPolicy = ScheduledEventsPolicy.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                if ("additionalCapabilities".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.additionalCapabilities = AdditionalCapabilities.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.osProfile = OSProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("diagnosticsProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.diagnosticsProfile = DiagnosticsProfile.fromJson(reader);
                    continue;
                }
                if ("availabilitySet".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.availabilitySet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("virtualMachineScaleSet".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.virtualMachineScaleSet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("proximityPlacementGroup".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.proximityPlacementGroup = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.priority = VirtualMachinePriorityTypes.fromString(reader.getString());
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.evictionPolicy = VirtualMachineEvictionPolicyTypes.fromString(reader.getString());
                    continue;
                }
                if ("billingProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.billingProfile = BillingProfile.fromJson(reader);
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.host = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("hostGroup".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.hostGroup = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.provisioningState = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.instanceView = VirtualMachineInstanceViewInner.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.licenseType = reader.getString();
                    continue;
                }
                if ("vmId".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.vmId = reader.getString();
                    continue;
                }
                if ("extensionsTimeBudget".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.extensionsTimeBudget = reader.getString();
                    continue;
                }
                if ("platformFaultDomain".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.platformFaultDomain = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("scheduledEventsProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.scheduledEventsProfile = ScheduledEventsProfile.fromJson(reader);
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.userData = reader.getString();
                    continue;
                }
                if ("capacityReservation".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.capacityReservation = CapacityReservationProfile.fromJson(reader);
                    continue;
                }
                if ("applicationProfile".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.applicationProfile = ApplicationProfile.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedVirtualMachinePropertiesInner.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachinePropertiesInner;
        });
    }
}

