/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RestorePointProperties
implements JsonSerializable<RestorePointProperties> {
    private List<ApiEntityReference> excludeDisks;
    private RestorePointSourceMetadata sourceMetadata;
    private String provisioningState;
    private ConsistencyModeTypes consistencyMode;
    private OffsetDateTime timeCreated;
    private ApiEntityReference sourceRestorePoint;
    private RestorePointInstanceView instanceView;

    public List<ApiEntityReference> excludeDisks() {
        return this.excludeDisks;
    }

    public RestorePointProperties withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        this.excludeDisks = excludeDisks;
        return this;
    }

    public RestorePointSourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public RestorePointProperties withSourceMetadata(RestorePointSourceMetadata sourceMetadata) {
        this.sourceMetadata = sourceMetadata;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ConsistencyModeTypes consistencyMode() {
        return this.consistencyMode;
    }

    public RestorePointProperties withConsistencyMode(ConsistencyModeTypes consistencyMode) {
        this.consistencyMode = consistencyMode;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public RestorePointProperties withTimeCreated(OffsetDateTime timeCreated) {
        this.timeCreated = timeCreated;
        return this;
    }

    public ApiEntityReference sourceRestorePoint() {
        return this.sourceRestorePoint;
    }

    public RestorePointProperties withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        this.sourceRestorePoint = sourceRestorePoint;
        return this;
    }

    public RestorePointInstanceView instanceView() {
        return this.instanceView;
    }

    public void validate() {
        if (this.excludeDisks() != null) {
            this.excludeDisks().forEach(e -> e.validate());
        }
        if (this.sourceMetadata() != null) {
            this.sourceMetadata().validate();
        }
        if (this.sourceRestorePoint() != null) {
            this.sourceRestorePoint().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("excludeDisks", this.excludeDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("sourceMetadata", (JsonSerializable)this.sourceMetadata);
        jsonWriter.writeStringField("consistencyMode", this.consistencyMode == null ? null : this.consistencyMode.toString());
        jsonWriter.writeStringField("timeCreated", this.timeCreated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeCreated));
        jsonWriter.writeJsonField("sourceRestorePoint", (JsonSerializable)this.sourceRestorePoint);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointProperties)jsonReader.readObject(reader -> {
            RestorePointProperties deserializedRestorePointProperties = new RestorePointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("excludeDisks".equals(fieldName)) {
                    List excludeDisks;
                    deserializedRestorePointProperties.excludeDisks = excludeDisks = reader.readArray(reader1 -> ApiEntityReference.fromJson(reader1));
                    continue;
                }
                if ("sourceMetadata".equals(fieldName)) {
                    deserializedRestorePointProperties.sourceMetadata = RestorePointSourceMetadata.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRestorePointProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("consistencyMode".equals(fieldName)) {
                    deserializedRestorePointProperties.consistencyMode = ConsistencyModeTypes.fromString(reader.getString());
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedRestorePointProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceRestorePoint".equals(fieldName)) {
                    deserializedRestorePointProperties.sourceRestorePoint = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedRestorePointProperties.instanceView = RestorePointInstanceView.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointProperties;
        });
    }
}

