/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupInstanceView;
import com.azure.resourcemanager.compute.models.ResourceSharingProfile;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;

public final class CapacityReservationGroupProperties
implements JsonSerializable<CapacityReservationGroupProperties> {
    private List<SubResourceReadOnly> capacityReservations;
    private List<SubResourceReadOnly> virtualMachinesAssociated;
    private CapacityReservationGroupInstanceView instanceView;
    private ResourceSharingProfile sharingProfile;

    public List<SubResourceReadOnly> capacityReservations() {
        return this.capacityReservations;
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    public CapacityReservationGroupInstanceView instanceView() {
        return this.instanceView;
    }

    public ResourceSharingProfile sharingProfile() {
        return this.sharingProfile;
    }

    public CapacityReservationGroupProperties withSharingProfile(ResourceSharingProfile sharingProfile) {
        this.sharingProfile = sharingProfile;
        return this;
    }

    public void validate() {
        if (this.capacityReservations() != null) {
            this.capacityReservations().forEach(e -> e.validate());
        }
        if (this.virtualMachinesAssociated() != null) {
            this.virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.sharingProfile() != null) {
            this.sharingProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sharingProfile", (JsonSerializable)this.sharingProfile);
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityReservationGroupProperties)jsonReader.readObject(reader -> {
            CapacityReservationGroupProperties deserializedCapacityReservationGroupProperties = new CapacityReservationGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacityReservations".equals(fieldName)) {
                    List capacityReservations;
                    deserializedCapacityReservationGroupProperties.capacityReservations = capacityReservations = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    continue;
                }
                if ("virtualMachinesAssociated".equals(fieldName)) {
                    List virtualMachinesAssociated;
                    deserializedCapacityReservationGroupProperties.virtualMachinesAssociated = virtualMachinesAssociated = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedCapacityReservationGroupProperties.instanceView = CapacityReservationGroupInstanceView.fromJson(reader);
                    continue;
                }
                if ("sharingProfile".equals(fieldName)) {
                    deserializedCapacityReservationGroupProperties.sharingProfile = ResourceSharingProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationGroupProperties;
        });
    }
}

