// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Sharing status of current gallery.
 */
@Fluent
public final class SharingStatus implements JsonSerializable<SharingStatus> {
    /*
     * Aggregated sharing state of current gallery.
     */
    private SharingState aggregatedState;

    /*
     * Summary of all regional sharing status.
     */
    private List<RegionalSharingStatus> summary;

    /**
     * Creates an instance of SharingStatus class.
     */
    public SharingStatus() {
    }

    /**
     * Get the aggregatedState property: Aggregated sharing state of current gallery.
     * 
     * @return the aggregatedState value.
     */
    public SharingState aggregatedState() {
        return this.aggregatedState;
    }

    /**
     * Get the summary property: Summary of all regional sharing status.
     * 
     * @return the summary value.
     */
    public List<RegionalSharingStatus> summary() {
        return this.summary;
    }

    /**
     * Set the summary property: Summary of all regional sharing status.
     * 
     * @param summary the summary value to set.
     * @return the SharingStatus object itself.
     */
    public SharingStatus withSummary(List<RegionalSharingStatus> summary) {
        this.summary = summary;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (summary() != null) {
            summary().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("summary", this.summary, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharingStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharingStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharingStatus.
     */
    public static SharingStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharingStatus deserializedSharingStatus = new SharingStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("aggregatedState".equals(fieldName)) {
                    deserializedSharingStatus.aggregatedState = SharingState.fromString(reader.getString());
                } else if ("summary".equals(fieldName)) {
                    List<RegionalSharingStatus> summary
                        = reader.readArray(reader1 -> RegionalSharingStatus.fromJson(reader1));
                    deserializedSharingStatus.summary = summary;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharingStatus;
        });
    }
}
