// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GallerySoftDeletedResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Soft-deleted Resources operation response.
 */
@Fluent
public final class GallerySoftDeletedResourceList implements JsonSerializable<GallerySoftDeletedResourceList> {
    /*
     * A list of soft-deleted resources.
     */
    private List<GallerySoftDeletedResourceInner> value;

    /*
     * The uri to fetch the next page of soft-deleted resources. Call ListNext() with this to fetch the next page of
     * soft-deleted resources.
     */
    private String nextLink;

    /**
     * Creates an instance of GallerySoftDeletedResourceList class.
     */
    public GallerySoftDeletedResourceList() {
    }

    /**
     * Get the value property: A list of soft-deleted resources.
     * 
     * @return the value value.
     */
    public List<GallerySoftDeletedResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of soft-deleted resources.
     * 
     * @param value the value value to set.
     * @return the GallerySoftDeletedResourceList object itself.
     */
    public GallerySoftDeletedResourceList withValue(List<GallerySoftDeletedResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of soft-deleted resources. Call ListNext() with this to
     * fetch the next page of soft-deleted resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of soft-deleted resources. Call ListNext() with this to
     * fetch the next page of soft-deleted resources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GallerySoftDeletedResourceList object itself.
     */
    public GallerySoftDeletedResourceList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model GallerySoftDeletedResourceList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GallerySoftDeletedResourceList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GallerySoftDeletedResourceList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GallerySoftDeletedResourceList if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GallerySoftDeletedResourceList.
     */
    public static GallerySoftDeletedResourceList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GallerySoftDeletedResourceList deserializedGallerySoftDeletedResourceList
                = new GallerySoftDeletedResourceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GallerySoftDeletedResourceInner> value
                        = reader.readArray(reader1 -> GallerySoftDeletedResourceInner.fromJson(reader1));
                    deserializedGallerySoftDeletedResourceList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGallerySoftDeletedResourceList;
        });
    }
}
