// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Gallery InVMAccessControlProfile Versions operation response.
 */
@Fluent
public final class GalleryInVMAccessControlProfileVersionList
    implements JsonSerializable<GalleryInVMAccessControlProfileVersionList> {
    /*
     * A list of Gallery InVMAccessControlProfile Versions.
     */
    private List<GalleryInVMAccessControlProfileVersionInner> value;

    /*
     * The uri to fetch the next page of inVMAccessControlProfile versions. Call ListNext() with this to fetch the next
     * page of gallery inVMAccessControlProfile versions.
     */
    private String nextLink;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileVersionList class.
     */
    public GalleryInVMAccessControlProfileVersionList() {
    }

    /**
     * Get the value property: A list of Gallery InVMAccessControlProfile Versions.
     * 
     * @return the value value.
     */
    public List<GalleryInVMAccessControlProfileVersionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of Gallery InVMAccessControlProfile Versions.
     * 
     * @param value the value value to set.
     * @return the GalleryInVMAccessControlProfileVersionList object itself.
     */
    public GalleryInVMAccessControlProfileVersionList
        withValue(List<GalleryInVMAccessControlProfileVersionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of inVMAccessControlProfile versions. Call ListNext()
     * with this to fetch the next page of gallery inVMAccessControlProfile versions.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of inVMAccessControlProfile versions. Call ListNext()
     * with this to fetch the next page of gallery inVMAccessControlProfile versions.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryInVMAccessControlProfileVersionList object itself.
     */
    public GalleryInVMAccessControlProfileVersionList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model GalleryInVMAccessControlProfileVersionList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryInVMAccessControlProfileVersionList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileVersionList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileVersionList if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileVersionList.
     */
    public static GalleryInVMAccessControlProfileVersionList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionList deserializedGalleryInVMAccessControlProfileVersionList
                = new GalleryInVMAccessControlProfileVersionList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GalleryInVMAccessControlProfileVersionInner> value
                        = reader.readArray(reader1 -> GalleryInVMAccessControlProfileVersionInner.fromJson(reader1));
                    deserializedGalleryInVMAccessControlProfileVersionList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileVersionList;
        });
    }
}
