// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a Encryption Settings for a Disk.
 */
@Fluent
public final class DiskEncryptionSettings implements JsonSerializable<DiskEncryptionSettings> {
    /*
     * Specifies the location of the disk encryption key, which is a Key Vault Secret.
     */
    private KeyVaultSecretReference diskEncryptionKey;

    /*
     * Specifies the location of the key encryption key in Key Vault.
     */
    private KeyVaultKeyReference keyEncryptionKey;

    /*
     * Specifies whether disk encryption should be enabled on the virtual machine.
     */
    private Boolean enabled;

    /**
     * Creates an instance of DiskEncryptionSettings class.
     */
    public DiskEncryptionSettings() {
    }

    /**
     * Get the diskEncryptionKey property: Specifies the location of the disk encryption key, which is a Key Vault
     * Secret.
     * 
     * @return the diskEncryptionKey value.
     */
    public KeyVaultSecretReference diskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    /**
     * Set the diskEncryptionKey property: Specifies the location of the disk encryption key, which is a Key Vault
     * Secret.
     * 
     * @param diskEncryptionKey the diskEncryptionKey value to set.
     * @return the DiskEncryptionSettings object itself.
     */
    public DiskEncryptionSettings withDiskEncryptionKey(KeyVaultSecretReference diskEncryptionKey) {
        this.diskEncryptionKey = diskEncryptionKey;
        return this;
    }

    /**
     * Get the keyEncryptionKey property: Specifies the location of the key encryption key in Key Vault.
     * 
     * @return the keyEncryptionKey value.
     */
    public KeyVaultKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    /**
     * Set the keyEncryptionKey property: Specifies the location of the key encryption key in Key Vault.
     * 
     * @param keyEncryptionKey the keyEncryptionKey value to set.
     * @return the DiskEncryptionSettings object itself.
     */
    public DiskEncryptionSettings withKeyEncryptionKey(KeyVaultKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    /**
     * Get the enabled property: Specifies whether disk encryption should be enabled on the virtual machine.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Specifies whether disk encryption should be enabled on the virtual machine.
     * 
     * @param enabled the enabled value to set.
     * @return the DiskEncryptionSettings object itself.
     */
    public DiskEncryptionSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskEncryptionKey() != null) {
            diskEncryptionKey().validate();
        }
        if (keyEncryptionKey() != null) {
            keyEncryptionKey().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskEncryptionKey", this.diskEncryptionKey);
        jsonWriter.writeJsonField("keyEncryptionKey", this.keyEncryptionKey);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskEncryptionSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskEncryptionSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskEncryptionSettings.
     */
    public static DiskEncryptionSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionSettings deserializedDiskEncryptionSettings = new DiskEncryptionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskEncryptionKey".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.diskEncryptionKey = KeyVaultSecretReference.fromJson(reader);
                } else if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.keyEncryptionKey = KeyVaultKeyReference.fromJson(reader);
                } else if ("enabled".equals(fieldName)) {
                    deserializedDiskEncryptionSettings.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskEncryptionSettings;
        });
    }
}
