// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Indicates the target Virtual Machine ScaleSet properties upon triggering a seamless migration without downtime of the
 * VMs via the ConvertToVirtualMachineScaleSet API.
 */
@Immutable
public final class DefaultVirtualMachineScaleSetInfo implements JsonSerializable<DefaultVirtualMachineScaleSetInfo> {
    /*
     * Indicates if the the maximum capacity of the default migrated Virtual Machine Scale Set after its migration will
     * be constrained to a limited number of VMs.
     */
    private Boolean constrainedMaximumCapacity;

    /*
     * The default Virtual Machine ScaleSet Uri that the Availability Set will be moved to upon triggering a seamless
     * migration via the ConvertToVirtualMachineScaleSet API.
     */
    private SubResource defaultVirtualMachineScaleSet;

    /**
     * Creates an instance of DefaultVirtualMachineScaleSetInfo class.
     */
    public DefaultVirtualMachineScaleSetInfo() {
    }

    /**
     * Get the constrainedMaximumCapacity property: Indicates if the the maximum capacity of the default migrated
     * Virtual Machine Scale Set after its migration will be constrained to a limited number of VMs.
     * 
     * @return the constrainedMaximumCapacity value.
     */
    public Boolean constrainedMaximumCapacity() {
        return this.constrainedMaximumCapacity;
    }

    /**
     * Get the defaultVirtualMachineScaleSet property: The default Virtual Machine ScaleSet Uri that the Availability
     * Set will be moved to upon triggering a seamless migration via the ConvertToVirtualMachineScaleSet API.
     * 
     * @return the defaultVirtualMachineScaleSet value.
     */
    public SubResource defaultVirtualMachineScaleSet() {
        return this.defaultVirtualMachineScaleSet;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DefaultVirtualMachineScaleSetInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DefaultVirtualMachineScaleSetInfo if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DefaultVirtualMachineScaleSetInfo.
     */
    public static DefaultVirtualMachineScaleSetInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DefaultVirtualMachineScaleSetInfo deserializedDefaultVirtualMachineScaleSetInfo
                = new DefaultVirtualMachineScaleSetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("constrainedMaximumCapacity".equals(fieldName)) {
                    deserializedDefaultVirtualMachineScaleSetInfo.constrainedMaximumCapacity
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultVirtualMachineScaleSet".equals(fieldName)) {
                    deserializedDefaultVirtualMachineScaleSetInfo.defaultVirtualMachineScaleSet
                        = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDefaultVirtualMachineScaleSetInfo;
        });
    }
}
