// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The List VmImages in EdgeZone operation response.
 */
@Fluent
public final class VmImagesInEdgeZoneListResultInner implements JsonSerializable<VmImagesInEdgeZoneListResultInner> {
    /*
     * The list of VMImages in EdgeZone
     */
    private List<VirtualMachineImageResourceInner> value;

    /*
     * The URI to fetch the next page of VMImages in EdgeZone. Call ListNext() with this URI to fetch the next page of
     * VmImages.
     */
    private String nextLink;

    /**
     * Creates an instance of VmImagesInEdgeZoneListResultInner class.
     */
    public VmImagesInEdgeZoneListResultInner() {
    }

    /**
     * Get the value property: The list of VMImages in EdgeZone.
     * 
     * @return the value value.
     */
    public List<VirtualMachineImageResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of VMImages in EdgeZone.
     * 
     * @param value the value value to set.
     * @return the VmImagesInEdgeZoneListResultInner object itself.
     */
    public VmImagesInEdgeZoneListResultInner withValue(List<VirtualMachineImageResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of VMImages in EdgeZone. Call ListNext() with this URI
     * to fetch the next page of VmImages.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of VMImages in EdgeZone. Call ListNext() with this URI
     * to fetch the next page of VmImages.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VmImagesInEdgeZoneListResultInner object itself.
     */
    public VmImagesInEdgeZoneListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VmImagesInEdgeZoneListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VmImagesInEdgeZoneListResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VmImagesInEdgeZoneListResultInner.
     */
    public static VmImagesInEdgeZoneListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VmImagesInEdgeZoneListResultInner deserializedVmImagesInEdgeZoneListResultInner
                = new VmImagesInEdgeZoneListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineImageResourceInner> value
                        = reader.readArray(reader1 -> VirtualMachineImageResourceInner.fromJson(reader1));
                    deserializedVmImagesInEdgeZoneListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVmImagesInEdgeZoneListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVmImagesInEdgeZoneListResultInner;
        });
    }
}
