// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response after calling a manual recovery walk.
 */
@Immutable
public final class RecoveryWalkResponseInner implements JsonSerializable<RecoveryWalkResponseInner> {
    /*
     * Whether the recovery walk was performed
     */
    private Boolean walkPerformed;

    /*
     * The next update domain that needs to be walked. Null means walk spanning all update domains has been completed
     */
    private Integer nextPlatformUpdateDomain;

    /**
     * Creates an instance of RecoveryWalkResponseInner class.
     */
    public RecoveryWalkResponseInner() {
    }

    /**
     * Get the walkPerformed property: Whether the recovery walk was performed.
     * 
     * @return the walkPerformed value.
     */
    public Boolean walkPerformed() {
        return this.walkPerformed;
    }

    /**
     * Get the nextPlatformUpdateDomain property: The next update domain that needs to be walked. Null means walk
     * spanning all update domains has been completed.
     * 
     * @return the nextPlatformUpdateDomain value.
     */
    public Integer nextPlatformUpdateDomain() {
        return this.nextPlatformUpdateDomain;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecoveryWalkResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecoveryWalkResponseInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecoveryWalkResponseInner.
     */
    public static RecoveryWalkResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecoveryWalkResponseInner deserializedRecoveryWalkResponseInner = new RecoveryWalkResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("walkPerformed".equals(fieldName)) {
                    deserializedRecoveryWalkResponseInner.walkPerformed = reader.getNullable(JsonReader::getBoolean);
                } else if ("nextPlatformUpdateDomain".equals(fieldName)) {
                    deserializedRecoveryWalkResponseInner.nextPlatformUpdateDomain
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecoveryWalkResponseInner;
        });
    }
}
