// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ImageVersionSecurityProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.ValidationsProfile;
import java.io.IOException;
import java.util.Map;

/**
 * Specifies information about the gallery image version that you want to create or update.
 */
@Fluent
public final class GalleryImageVersionInner extends Resource {
    /*
     * Describes the properties of a gallery image version.
     */
    private GalleryImageVersionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GalleryImageVersionInner class.
     */
    public GalleryImageVersionInner() {
    }

    /**
     * Get the innerProperties property: Describes the properties of a gallery image version.
     * 
     * @return the innerProperties value.
     */
    private GalleryImageVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryImageVersionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryImageVersionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image Version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryImageVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image Version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryImageVersionInner object itself.
     */
    public GalleryImageVersionInner withPublishingProfile(GalleryImageVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the storageProfile property: This is the storage profile of a Gallery Image Version.
     * 
     * @return the storageProfile value.
     */
    public GalleryImageVersionStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    /**
     * Set the storageProfile property: This is the storage profile of a Gallery Image Version.
     * 
     * @param storageProfile the storageProfile value to set.
     * @return the GalleryImageVersionInner object itself.
     */
    public GalleryImageVersionInner withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    /**
     * Get the safetyProfile property: This is the safety profile of the Gallery Image Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryImageVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    /**
     * Set the safetyProfile property: This is the safety profile of the Gallery Image Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryImageVersionInner object itself.
     */
    public GalleryImageVersionInner withSafetyProfile(GalleryImageVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    /**
     * Get the securityProfile property: The security profile of a gallery image version.
     * 
     * @return the securityProfile value.
     */
    public ImageVersionSecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    /**
     * Set the securityProfile property: The security profile of a gallery image version.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the GalleryImageVersionInner object itself.
     */
    public GalleryImageVersionInner withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    /**
     * Get the restore property: Indicates if this is a soft-delete resource restoration request.
     * 
     * @return the restore value.
     */
    public Boolean restore() {
        return this.innerProperties() == null ? null : this.innerProperties().restore();
    }

    /**
     * Set the restore property: Indicates if this is a soft-delete resource restoration request.
     * 
     * @param restore the restore value to set.
     * @return the GalleryImageVersionInner object itself.
     */
    public GalleryImageVersionInner withRestore(Boolean restore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageVersionProperties();
        }
        this.innerProperties().withRestore(restore);
        return this;
    }

    /**
     * Get the validationsProfile property: This is the validations profile of a Gallery Image Version.
     * 
     * @return the validationsProfile value.
     */
    public ValidationsProfile validationsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().validationsProfile();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryImageVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryImageVersionInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryImageVersionInner.
     */
    public static GalleryImageVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryImageVersionInner deserializedGalleryImageVersionInner = new GalleryImageVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryImageVersionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryImageVersionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryImageVersionInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGalleryImageVersionInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryImageVersionInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryImageVersionInner.innerProperties
                        = GalleryImageVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryImageVersionInner;
        });
    }
}
