// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The DiskAccessProperties model.
 */
@Immutable
public final class DiskAccessProperties implements JsonSerializable<DiskAccessProperties> {
    /*
     * A readonly collection of private endpoint connections created on the disk. Currently only one endpoint connection
     * is supported.
     */
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * The disk access resource provisioning state.
     */
    private String provisioningState;

    /*
     * The time when the disk access was created.
     */
    private OffsetDateTime timeCreated;

    /**
     * Creates an instance of DiskAccessProperties class.
     */
    public DiskAccessProperties() {
    }

    /**
     * Get the privateEndpointConnections property: A readonly collection of private endpoint connections created on the
     * disk. Currently only one endpoint connection is supported.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the provisioningState property: The disk access resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the timeCreated property: The time when the disk access was created.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskAccessProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskAccessProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskAccessProperties.
     */
    public static DiskAccessProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskAccessProperties deserializedDiskAccessProperties = new DiskAccessProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedDiskAccessProperties.privateEndpointConnections = privateEndpointConnections;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDiskAccessProperties.provisioningState = reader.getString();
                } else if ("timeCreated".equals(fieldName)) {
                    deserializedDiskAccessProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskAccessProperties;
        });
    }
}
