// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the Dedicated host.
 */
@Fluent
public final class DedicatedHostInner extends Resource {
    /*
     * Properties of the dedicated host.
     */
    private DedicatedHostProperties innerProperties;

    /*
     * SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List
     * Microsoft.Compute SKUs for a list of possible values.
     */
    private Sku sku;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DedicatedHostInner class.
     */
    public DedicatedHostInner() {
    }

    /**
     * Get the innerProperties property: Properties of the dedicated host.
     * 
     * @return the innerProperties value.
     */
    private DedicatedHostProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the sku property: SKU of the dedicated host for Hardware Generation and VM family. Only name is required to
     * be set. List Microsoft.Compute SKUs for a list of possible values.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU of the dedicated host for Hardware Generation and VM family. Only name is required to
     * be set. List Microsoft.Compute SKUs for a list of possible values.
     * 
     * @param sku the sku value to set.
     * @return the DedicatedHostInner object itself.
     */
    public DedicatedHostInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DedicatedHostInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the platformFaultDomain property: Fault domain of the dedicated host within a dedicated host group.
     * 
     * @return the platformFaultDomain value.
     */
    public Integer platformFaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomain();
    }

    /**
     * Set the platformFaultDomain property: Fault domain of the dedicated host within a dedicated host group.
     * 
     * @param platformFaultDomain the platformFaultDomain value to set.
     * @return the DedicatedHostInner object itself.
     */
    public DedicatedHostInner withPlatformFaultDomain(Integer platformFaultDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withPlatformFaultDomain(platformFaultDomain);
        return this;
    }

    /**
     * Get the autoReplaceOnFailure property: Specifies whether the dedicated host should be replaced automatically in
     * case of a failure. The value is defaulted to 'true' when not provided.
     * 
     * @return the autoReplaceOnFailure value.
     */
    public Boolean autoReplaceOnFailure() {
        return this.innerProperties() == null ? null : this.innerProperties().autoReplaceOnFailure();
    }

    /**
     * Set the autoReplaceOnFailure property: Specifies whether the dedicated host should be replaced automatically in
     * case of a failure. The value is defaulted to 'true' when not provided.
     * 
     * @param autoReplaceOnFailure the autoReplaceOnFailure value to set.
     * @return the DedicatedHostInner object itself.
     */
    public DedicatedHostInner withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withAutoReplaceOnFailure(autoReplaceOnFailure);
        return this;
    }

    /**
     * Get the hostId property: A unique id generated and assigned to the dedicated host by the platform. Does not
     * change throughout the lifetime of the host.
     * 
     * @return the hostId value.
     */
    public String hostId() {
        return this.innerProperties() == null ? null : this.innerProperties().hostId();
    }

    /**
     * Get the virtualMachines property: A list of references to all virtual machines in the Dedicated Host.
     * 
     * @return the virtualMachines value.
     */
    public List<SubResourceReadOnly> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    /**
     * Get the licenseType property: Specifies the software license type that will be applied to the VMs deployed on the
     * dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The
     * default value is: **None.**.
     * 
     * @return the licenseType value.
     */
    public DedicatedHostLicenseTypes licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    /**
     * Set the licenseType property: Specifies the software license type that will be applied to the VMs deployed on the
     * dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The
     * default value is: **None.**.
     * 
     * @param licenseType the licenseType value to set.
     * @return the DedicatedHostInner object itself.
     */
    public DedicatedHostInner withLicenseType(DedicatedHostLicenseTypes licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    /**
     * Get the provisioningTime property: The date when the host was first provisioned.
     * 
     * @return the provisioningTime value.
     */
    public OffsetDateTime provisioningTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningTime();
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the instanceView property: The dedicated host instance view.
     * 
     * @return the instanceView value.
     */
    public DedicatedHostInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the timeCreated property: Specifies the time at which the Dedicated Host resource was created. Minimum
     * api-version: 2021-11-01.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (sku() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sku in model DedicatedHostInner"));
        } else {
            sku().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHostInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DedicatedHostInner.
     */
    public static DedicatedHostInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostInner deserializedDedicatedHostInner = new DedicatedHostInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDedicatedHostInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDedicatedHostInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDedicatedHostInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDedicatedHostInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHostInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedDedicatedHostInner.sku = Sku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedDedicatedHostInner.innerProperties = DedicatedHostProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostInner;
        });
    }
}
