/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import java.io.IOException;

public final class AdditionalReplicaSet
implements JsonSerializable<AdditionalReplicaSet> {
    private StorageAccountType storageAccountType;
    private Integer regionalReplicaCount;

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public AdditionalReplicaSet withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public Integer regionalReplicaCount() {
        return this.regionalReplicaCount;
    }

    public AdditionalReplicaSet withRegionalReplicaCount(Integer regionalReplicaCount) {
        this.regionalReplicaCount = regionalReplicaCount;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeNumberField("regionalReplicaCount", (Number)this.regionalReplicaCount);
        return jsonWriter.writeEndObject();
    }

    public static AdditionalReplicaSet fromJson(JsonReader jsonReader) throws IOException {
        return (AdditionalReplicaSet)jsonReader.readObject(reader -> {
            AdditionalReplicaSet deserializedAdditionalReplicaSet = new AdditionalReplicaSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountType".equals(fieldName)) {
                    deserializedAdditionalReplicaSet.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("regionalReplicaCount".equals(fieldName)) {
                    deserializedAdditionalReplicaSet.regionalReplicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdditionalReplicaSet;
        });
    }
}

