// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Input for InstallPatches on a Windows VM, as directly received by the API.
 */
@Fluent
public final class WindowsParameters implements JsonSerializable<WindowsParameters> {
    /*
     * The update classifications to select when installing patches for Windows.
     */
    private List<VMGuestPatchClassificationWindows> classificationsToInclude;

    /*
     * Kbs to include in the patch operation
     */
    private List<String> kbNumbersToInclude;

    /*
     * Kbs to exclude in the patch operation
     */
    private List<String> kbNumbersToExclude;

    /*
     * Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
     */
    private Boolean excludeKbsRequiringReboot;

    /*
     * This is used to install patches that were published on or before this given max published date.
     */
    private OffsetDateTime maxPatchPublishDate;

    /**
     * Creates an instance of WindowsParameters class.
     */
    public WindowsParameters() {
    }

    /**
     * Get the classificationsToInclude property: The update classifications to select when installing patches for
     * Windows.
     * 
     * @return the classificationsToInclude value.
     */
    public List<VMGuestPatchClassificationWindows> classificationsToInclude() {
        return this.classificationsToInclude;
    }

    /**
     * Set the classificationsToInclude property: The update classifications to select when installing patches for
     * Windows.
     * 
     * @param classificationsToInclude the classificationsToInclude value to set.
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters
        withClassificationsToInclude(List<VMGuestPatchClassificationWindows> classificationsToInclude) {
        this.classificationsToInclude = classificationsToInclude;
        return this;
    }

    /**
     * Get the kbNumbersToInclude property: Kbs to include in the patch operation.
     * 
     * @return the kbNumbersToInclude value.
     */
    public List<String> kbNumbersToInclude() {
        return this.kbNumbersToInclude;
    }

    /**
     * Set the kbNumbersToInclude property: Kbs to include in the patch operation.
     * 
     * @param kbNumbersToInclude the kbNumbersToInclude value to set.
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withKbNumbersToInclude(List<String> kbNumbersToInclude) {
        this.kbNumbersToInclude = kbNumbersToInclude;
        return this;
    }

    /**
     * Get the kbNumbersToExclude property: Kbs to exclude in the patch operation.
     * 
     * @return the kbNumbersToExclude value.
     */
    public List<String> kbNumbersToExclude() {
        return this.kbNumbersToExclude;
    }

    /**
     * Set the kbNumbersToExclude property: Kbs to exclude in the patch operation.
     * 
     * @param kbNumbersToExclude the kbNumbersToExclude value to set.
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withKbNumbersToExclude(List<String> kbNumbersToExclude) {
        this.kbNumbersToExclude = kbNumbersToExclude;
        return this;
    }

    /**
     * Get the excludeKbsRequiringReboot property: Filters out Kbs that don't have an InstallationRebootBehavior of
     * 'NeverReboots' when this is set to true.
     * 
     * @return the excludeKbsRequiringReboot value.
     */
    public Boolean excludeKbsRequiringReboot() {
        return this.excludeKbsRequiringReboot;
    }

    /**
     * Set the excludeKbsRequiringReboot property: Filters out Kbs that don't have an InstallationRebootBehavior of
     * 'NeverReboots' when this is set to true.
     * 
     * @param excludeKbsRequiringReboot the excludeKbsRequiringReboot value to set.
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withExcludeKbsRequiringReboot(Boolean excludeKbsRequiringReboot) {
        this.excludeKbsRequiringReboot = excludeKbsRequiringReboot;
        return this;
    }

    /**
     * Get the maxPatchPublishDate property: This is used to install patches that were published on or before this given
     * max published date.
     * 
     * @return the maxPatchPublishDate value.
     */
    public OffsetDateTime maxPatchPublishDate() {
        return this.maxPatchPublishDate;
    }

    /**
     * Set the maxPatchPublishDate property: This is used to install patches that were published on or before this given
     * max published date.
     * 
     * @param maxPatchPublishDate the maxPatchPublishDate value to set.
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withMaxPatchPublishDate(OffsetDateTime maxPatchPublishDate) {
        this.maxPatchPublishDate = maxPatchPublishDate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("classificationsToInclude", this.classificationsToInclude,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("kbNumbersToInclude", this.kbNumbersToInclude,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("kbNumbersToExclude", this.kbNumbersToExclude,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("excludeKbsRequiringReboot", this.excludeKbsRequiringReboot);
        jsonWriter.writeStringField("maxPatchPublishDate",
            this.maxPatchPublishDate == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.maxPatchPublishDate));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WindowsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WindowsParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WindowsParameters.
     */
    public static WindowsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsParameters deserializedWindowsParameters = new WindowsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("classificationsToInclude".equals(fieldName)) {
                    List<VMGuestPatchClassificationWindows> classificationsToInclude = reader
                        .readArray(reader1 -> VMGuestPatchClassificationWindows.fromString(reader1.getString()));
                    deserializedWindowsParameters.classificationsToInclude = classificationsToInclude;
                } else if ("kbNumbersToInclude".equals(fieldName)) {
                    List<String> kbNumbersToInclude = reader.readArray(reader1 -> reader1.getString());
                    deserializedWindowsParameters.kbNumbersToInclude = kbNumbersToInclude;
                } else if ("kbNumbersToExclude".equals(fieldName)) {
                    List<String> kbNumbersToExclude = reader.readArray(reader1 -> reader1.getString());
                    deserializedWindowsParameters.kbNumbersToExclude = kbNumbersToExclude;
                } else if ("excludeKbsRequiringReboot".equals(fieldName)) {
                    deserializedWindowsParameters.excludeKbsRequiringReboot
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("maxPatchPublishDate".equals(fieldName)) {
                    deserializedWindowsParameters.maxPatchPublishDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWindowsParameters;
        });
    }
}
