// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This property specifies the status of the validationProfile of the image version.
 */
public final class ValidationStatus extends ExpandableStringEnum<ValidationStatus> {
    /**
     * Static value Unknown for ValidationStatus.
     */
    public static final ValidationStatus UNKNOWN = fromString("Unknown");

    /**
     * Static value Failed for ValidationStatus.
     */
    public static final ValidationStatus FAILED = fromString("Failed");

    /**
     * Static value Succeeded for ValidationStatus.
     */
    public static final ValidationStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Creates a new instance of ValidationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ValidationStatus() {
    }

    /**
     * Creates or finds a ValidationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ValidationStatus.
     */
    public static ValidationStatus fromString(String name) {
        return fromString(name, ValidationStatus.class);
    }

    /**
     * Gets known ValidationStatus values.
     * 
     * @return known ValidationStatus values.
     */
    public static Collection<ValidationStatus> values() {
        return values(ValidationStatus.class);
    }
}
