// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about rollback on failed VM instances after a OS Upgrade operation.
 */
@Immutable
public final class RollbackStatusInfo implements JsonSerializable<RollbackStatusInfo> {
    /*
     * The number of instances which have been successfully rolled back.
     */
    private Integer successfullyRolledbackInstanceCount;

    /*
     * The number of instances which failed to rollback.
     */
    private Integer failedRolledbackInstanceCount;

    /*
     * Error details if OS rollback failed.
     */
    private ApiError rollbackError;

    /**
     * Creates an instance of RollbackStatusInfo class.
     */
    public RollbackStatusInfo() {
    }

    /**
     * Get the successfullyRolledbackInstanceCount property: The number of instances which have been successfully rolled
     * back.
     * 
     * @return the successfullyRolledbackInstanceCount value.
     */
    public Integer successfullyRolledbackInstanceCount() {
        return this.successfullyRolledbackInstanceCount;
    }

    /**
     * Get the failedRolledbackInstanceCount property: The number of instances which failed to rollback.
     * 
     * @return the failedRolledbackInstanceCount value.
     */
    public Integer failedRolledbackInstanceCount() {
        return this.failedRolledbackInstanceCount;
    }

    /**
     * Get the rollbackError property: Error details if OS rollback failed.
     * 
     * @return the rollbackError value.
     */
    public ApiError rollbackError() {
        return this.rollbackError;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rollbackError() != null) {
            rollbackError().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RollbackStatusInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RollbackStatusInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RollbackStatusInfo.
     */
    public static RollbackStatusInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RollbackStatusInfo deserializedRollbackStatusInfo = new RollbackStatusInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("successfullyRolledbackInstanceCount".equals(fieldName)) {
                    deserializedRollbackStatusInfo.successfullyRolledbackInstanceCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("failedRolledbackInstanceCount".equals(fieldName)) {
                    deserializedRollbackStatusInfo.failedRolledbackInstanceCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("rollbackError".equals(fieldName)) {
                    deserializedRollbackStatusInfo.rollbackError = ApiError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRollbackStatusInfo;
        });
    }
}
