// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A policy violation reported against a gallery artifact.
 */
@Fluent
public final class PolicyViolation implements JsonSerializable<PolicyViolation> {
    /*
     * Describes the nature of the policy violation.
     */
    private PolicyViolationCategory category;

    /*
     * Describes specific details about why this policy violation was reported.
     */
    private String details;

    /**
     * Creates an instance of PolicyViolation class.
     */
    public PolicyViolation() {
    }

    /**
     * Get the category property: Describes the nature of the policy violation.
     * 
     * @return the category value.
     */
    public PolicyViolationCategory category() {
        return this.category;
    }

    /**
     * Set the category property: Describes the nature of the policy violation.
     * 
     * @param category the category value to set.
     * @return the PolicyViolation object itself.
     */
    public PolicyViolation withCategory(PolicyViolationCategory category) {
        this.category = category;
        return this;
    }

    /**
     * Get the details property: Describes specific details about why this policy violation was reported.
     * 
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Set the details property: Describes specific details about why this policy violation was reported.
     * 
     * @param details the details value to set.
     * @return the PolicyViolation object itself.
     */
    public PolicyViolation withDetails(String details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeStringField("details", this.details);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyViolation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyViolation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyViolation.
     */
    public static PolicyViolation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyViolation deserializedPolicyViolation = new PolicyViolation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("category".equals(fieldName)) {
                    deserializedPolicyViolation.category = PolicyViolationCategory.fromString(reader.getString());
                } else if ("details".equals(fieldName)) {
                    deserializedPolicyViolation.details = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyViolation;
        });
    }
}
