// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the disk image base class.
 */
@Fluent
public class GalleryDiskImage implements JsonSerializable<GalleryDiskImage> {
    /*
     * This property indicates the size of the VHD to be created.
     */
    private Integer sizeInGB;

    /*
     * The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    private HostCaching hostCaching;

    /*
     * The source for the disk image.
     */
    private GalleryDiskImageSource source;

    /**
     * Creates an instance of GalleryDiskImage class.
     */
    public GalleryDiskImage() {
    }

    /**
     * Get the sizeInGB property: This property indicates the size of the VHD to be created.
     * 
     * @return the sizeInGB value.
     */
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    /**
     * Set the sizeInGB property: This property indicates the size of the VHD to be created.
     * 
     * @param sizeInGB the sizeInGB value to set.
     * @return the GalleryDiskImage object itself.
     */
    GalleryDiskImage withSizeInGB(Integer sizeInGB) {
        this.sizeInGB = sizeInGB;
        return this;
    }

    /**
     * Get the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     * 
     * @return the hostCaching value.
     */
    public HostCaching hostCaching() {
        return this.hostCaching;
    }

    /**
     * Set the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     * 
     * @param hostCaching the hostCaching value to set.
     * @return the GalleryDiskImage object itself.
     */
    public GalleryDiskImage withHostCaching(HostCaching hostCaching) {
        this.hostCaching = hostCaching;
        return this;
    }

    /**
     * Get the source property: The source for the disk image.
     * 
     * @return the source value.
     */
    public GalleryDiskImageSource source() {
        return this.source;
    }

    /**
     * Set the source property: The source for the disk image.
     * 
     * @param source the source value to set.
     * @return the GalleryDiskImage object itself.
     */
    public GalleryDiskImage withSource(GalleryDiskImageSource source) {
        this.source = source;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostCaching", this.hostCaching == null ? null : this.hostCaching.toString());
        jsonWriter.writeJsonField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryDiskImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryDiskImage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryDiskImage.
     */
    public static GalleryDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryDiskImage deserializedGalleryDiskImage = new GalleryDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sizeInGB".equals(fieldName)) {
                    deserializedGalleryDiskImage.sizeInGB = reader.getNullable(JsonReader::getInt);
                } else if ("hostCaching".equals(fieldName)) {
                    deserializedGalleryDiskImage.hostCaching = HostCaching.fromString(reader.getString());
                } else if ("source".equals(fieldName)) {
                    deserializedGalleryDiskImage.source = GalleryDiskImageSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryDiskImage;
        });
    }
}
