// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a cloud service extension profile.
 */
@Fluent
public final class CloudServiceExtensionProfile implements JsonSerializable<CloudServiceExtensionProfile> {
    /*
     * List of extensions for the cloud service.
     */
    private List<Extension> extensions;

    /**
     * Creates an instance of CloudServiceExtensionProfile class.
     */
    public CloudServiceExtensionProfile() {
    }

    /**
     * Get the extensions property: List of extensions for the cloud service.
     * 
     * @return the extensions value.
     */
    public List<Extension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: List of extensions for the cloud service.
     * 
     * @param extensions the extensions value to set.
     * @return the CloudServiceExtensionProfile object itself.
     */
    public CloudServiceExtensionProfile withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceExtensionProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceExtensionProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CloudServiceExtensionProfile.
     */
    public static CloudServiceExtensionProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceExtensionProfile deserializedCloudServiceExtensionProfile = new CloudServiceExtensionProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("extensions".equals(fieldName)) {
                    List<Extension> extensions = reader.readArray(reader1 -> Extension.fromJson(reader1));
                    deserializedCloudServiceExtensionProfile.extensions = extensions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceExtensionProfile;
        });
    }
}
