// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the sku of an Availability Set. Use 'Aligned' for virtual machines with managed disks and 'Classic' for
 * virtual machines with unmanaged disks. Default value is 'Classic'.
 */
public final class AvailabilitySetSkuTypes extends ExpandableStringEnum<AvailabilitySetSkuTypes> {
    /**
     * Static value Classic for AvailabilitySetSkuTypes.
     */
    public static final AvailabilitySetSkuTypes CLASSIC = fromString("Classic");

    /**
     * Static value Aligned for AvailabilitySetSkuTypes.
     */
    public static final AvailabilitySetSkuTypes ALIGNED = fromString("Aligned");

    /**
     * Creates a new instance of AvailabilitySetSkuTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AvailabilitySetSkuTypes() {
    }

    /**
     * Creates or finds a AvailabilitySetSkuTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AvailabilitySetSkuTypes.
     */
    public static AvailabilitySetSkuTypes fromString(String name) {
        return fromString(name, AvailabilitySetSkuTypes.class);
    }

    /**
     * Gets known AvailabilitySetSkuTypes values.
     * 
     * @return known AvailabilitySetSkuTypes values.
     */
    public static Collection<AvailabilitySetSkuTypes> values() {
        return values(AvailabilitySetSkuTypes.class);
    }
}
