// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The List Extension operation response.
 */
@Fluent
public final class VirtualMachineExtensionsListResultInner
    implements JsonSerializable<VirtualMachineExtensionsListResultInner> {
    /*
     * The list of extensions
     */
    private List<VirtualMachineExtensionInner> value;

    /**
     * Creates an instance of VirtualMachineExtensionsListResultInner class.
     */
    public VirtualMachineExtensionsListResultInner() {
    }

    /**
     * Get the value property: The list of extensions.
     * 
     * @return the value value.
     */
    public List<VirtualMachineExtensionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of extensions.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineExtensionsListResultInner object itself.
     */
    public VirtualMachineExtensionsListResultInner withValue(List<VirtualMachineExtensionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineExtensionsListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineExtensionsListResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineExtensionsListResultInner.
     */
    public static VirtualMachineExtensionsListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineExtensionsListResultInner deserializedVirtualMachineExtensionsListResultInner
                = new VirtualMachineExtensionsListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineExtensionInner> value
                        = reader.readArray(reader1 -> VirtualMachineExtensionInner.fromJson(reader1));
                    deserializedVirtualMachineExtensionsListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineExtensionsListResultInner;
        });
    }
}
