// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;

/**
 * Dedicated Host Group Properties.
 */
@Fluent
public final class DedicatedHostGroupProperties implements JsonSerializable<DedicatedHostGroupProperties> {
    /*
     * Number of fault domains that the host group can span.
     */
    private int platformFaultDomainCount;

    /*
     * A list of references to all dedicated hosts in the dedicated host group.
     */
    private List<SubResourceReadOnly> hosts;

    /*
     * The dedicated host group instance view, which has the list of instance view of the dedicated hosts under the
     * dedicated host group.
     */
    private DedicatedHostGroupInstanceView instanceView;

    /*
     * Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated
     * host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under
     * the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
     */
    private Boolean supportAutomaticPlacement;

    /*
     * Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
     */
    private DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities;

    /**
     * Creates an instance of DedicatedHostGroupProperties class.
     */
    public DedicatedHostGroupProperties() {
    }

    /**
     * Get the platformFaultDomainCount property: Number of fault domains that the host group can span.
     * 
     * @return the platformFaultDomainCount value.
     */
    public int platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    /**
     * Set the platformFaultDomainCount property: Number of fault domains that the host group can span.
     * 
     * @param platformFaultDomainCount the platformFaultDomainCount value to set.
     * @return the DedicatedHostGroupProperties object itself.
     */
    public DedicatedHostGroupProperties withPlatformFaultDomainCount(int platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    /**
     * Get the hosts property: A list of references to all dedicated hosts in the dedicated host group.
     * 
     * @return the hosts value.
     */
    public List<SubResourceReadOnly> hosts() {
        return this.hosts;
    }

    /**
     * Get the instanceView property: The dedicated host group instance view, which has the list of instance view of the
     * dedicated hosts under the dedicated host group.
     * 
     * @return the instanceView value.
     */
    public DedicatedHostGroupInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the supportAutomaticPlacement property: Specifies whether virtual machines or virtual machine scale sets can
     * be placed automatically on the dedicated host group. Automatic placement means resources are allocated on
     * dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when
     * not provided. Minimum api-version: 2020-06-01.
     * 
     * @return the supportAutomaticPlacement value.
     */
    public Boolean supportAutomaticPlacement() {
        return this.supportAutomaticPlacement;
    }

    /**
     * Set the supportAutomaticPlacement property: Specifies whether virtual machines or virtual machine scale sets can
     * be placed automatically on the dedicated host group. Automatic placement means resources are allocated on
     * dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when
     * not provided. Minimum api-version: 2020-06-01.
     * 
     * @param supportAutomaticPlacement the supportAutomaticPlacement value to set.
     * @return the DedicatedHostGroupProperties object itself.
     */
    public DedicatedHostGroupProperties withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        this.supportAutomaticPlacement = supportAutomaticPlacement;
        return this;
    }

    /**
     * Get the additionalCapabilities property: Enables or disables a capability on the dedicated host group. Minimum
     * api-version: 2022-03-01.
     * 
     * @return the additionalCapabilities value.
     */
    public DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    /**
     * Set the additionalCapabilities property: Enables or disables a capability on the dedicated host group. Minimum
     * api-version: 2022-03-01.
     * 
     * @param additionalCapabilities the additionalCapabilities value to set.
     * @return the DedicatedHostGroupProperties object itself.
     */
    public DedicatedHostGroupProperties
        withAdditionalCapabilities(DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hosts() != null) {
            hosts().forEach(e -> e.validate());
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
        if (additionalCapabilities() != null) {
            additionalCapabilities().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("platformFaultDomainCount", this.platformFaultDomainCount);
        jsonWriter.writeBooleanField("supportAutomaticPlacement", this.supportAutomaticPlacement);
        jsonWriter.writeJsonField("additionalCapabilities", this.additionalCapabilities);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostGroupProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DedicatedHostGroupProperties.
     */
    public static DedicatedHostGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostGroupProperties deserializedDedicatedHostGroupProperties = new DedicatedHostGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("platformFaultDomainCount".equals(fieldName)) {
                    deserializedDedicatedHostGroupProperties.platformFaultDomainCount = reader.getInt();
                } else if ("hosts".equals(fieldName)) {
                    List<SubResourceReadOnly> hosts
                        = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    deserializedDedicatedHostGroupProperties.hosts = hosts;
                } else if ("instanceView".equals(fieldName)) {
                    deserializedDedicatedHostGroupProperties.instanceView
                        = DedicatedHostGroupInstanceView.fromJson(reader);
                } else if ("supportAutomaticPlacement".equals(fieldName)) {
                    deserializedDedicatedHostGroupProperties.supportAutomaticPlacement
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("additionalCapabilities".equals(fieldName)) {
                    deserializedDedicatedHostGroupProperties.additionalCapabilities
                        = DedicatedHostGroupPropertiesAdditionalCapabilities.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostGroupProperties;
        });
    }
}
