/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.Response;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.models.DiskInstanceView;
import com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

class WindowsVolumeNoAADEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineInner virtualMachine;

    WindowsVolumeNoAADEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.WINDOWS;
    }

    @Override
    public String progressMessage() {
        return String.format("OSDisk: %s DataDisk: %s", new Object[]{this.osDiskStatus(), this.dataDiskStatus()});
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return EncryptionStatus.UNKNOWN;
        }
        for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            if (diskInstanceView.encryptionSettings() == null) continue;
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                EncryptionStatus encryptionStatus = WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code());
                if (encryptionStatus == null) continue;
                return encryptionStatus;
            }
        }
        return EncryptionStatus.UNKNOWN;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return EncryptionStatus.UNKNOWN;
        }
        HashSet<EncryptionStatus> encryptStatuses = new HashSet<EncryptionStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            if (diskInstanceView.encryptionSettings() != null) continue;
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                EncryptionStatus encryptionStatus = WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code());
                if (encryptionStatus == null) continue;
                encryptStatuses.add(encryptionStatus);
                continue block0;
            }
        }
        if (encryptStatuses.isEmpty()) {
            return EncryptionStatus.UNKNOWN;
        }
        if (encryptStatuses.size() == 1) {
            return (EncryptionStatus)((Object)encryptStatuses.iterator().next());
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.UNKNOWN)) {
            return EncryptionStatus.UNKNOWN;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.NOT_MOUNTED)) {
            return EncryptionStatus.NOT_MOUNTED;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.ENCRYPTION_INPROGRESS)) {
            return EncryptionStatus.ENCRYPTION_INPROGRESS;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.VM_RESTART_PENDING)) {
            return EncryptionStatus.VM_RESTART_PENDING;
        }
        return EncryptionStatus.UNKNOWN;
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return new HashMap<String, InstanceViewStatus>();
        }
        HashMap<String, InstanceViewStatus> div = new HashMap<String, InstanceViewStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                if (WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code()) == null) continue;
                div.put(diskInstanceView.name(), status);
                continue block0;
            }
        }
        return div;
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        WindowsVolumeNoAADEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().map(virtualMachine -> {
            self.virtualMachine = virtualMachine;
            return self;
        });
    }

    private Mono<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupWithResponseAsync(this.rgName, this.vmName, InstanceViewTypes.INSTANCE_VIEW).map(Response::getValue);
    }

    private static EncryptionStatus encryptionStatusFromCode(String code) {
        if (code != null && code.toLowerCase(Locale.ROOT).startsWith("encryptionstate")) {
            String[] parts = code.split("/", 2);
            if (parts.length != 2) {
                return EncryptionStatus.UNKNOWN;
            }
            return EncryptionStatus.fromString(parts[1]);
        }
        return null;
    }
}

