/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.VirtualMachineScaleSetVMsClient;
import com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.implementation.UnmanagedDataDiskImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineDataDiskImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineInstanceViewImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetVMInstanceExtensionImpl;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DataDisk;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.azure.resourcemanager.compute.models.NetworkInterfaceReference;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PowerState;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.compute.models.VirtualMachineDataDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.compute.models.VirtualMachineInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVM;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMInstanceExtension;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProtectionPolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineUnmanagedDataDisk;
import com.azure.resourcemanager.network.models.VirtualMachineScaleSetNetworkInterface;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class VirtualMachineScaleSetVMImpl
extends ChildResourceImpl<VirtualMachineScaleSetVMInner, VirtualMachineScaleSetImpl, VirtualMachineScaleSet>
implements VirtualMachineScaleSetVM,
VirtualMachineScaleSetVM.Update {
    private VirtualMachineInstanceView virtualMachineInstanceView;
    private final VirtualMachineScaleSetVMsClient client;
    private final ComputeManager computeManager;
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetVMImpl.class);
    private final ManagedDataDiskCollection managedDataDisks = new ManagedDataDiskCollection();

    VirtualMachineScaleSetVMImpl(VirtualMachineScaleSetVMInner inner, VirtualMachineScaleSetImpl parent, VirtualMachineScaleSetVMsClient client, ComputeManager computeManager) {
        super((Object)inner, (Object)parent);
        this.client = client;
        this.computeManager = computeManager;
        VirtualMachineScaleSetVMInstanceViewInner instanceViewInner = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).instanceView();
        if (instanceViewInner != null) {
            this.updateInstanceView(instanceViewInner);
        } else {
            this.virtualMachineInstanceView = null;
        }
    }

    public String id() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).id();
    }

    public String name() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).name();
    }

    public String regionName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).location();
    }

    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    public String type() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).type();
    }

    public Map<String, String> tags() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).tags() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        return Collections.unmodifiableMap(((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).tags());
    }

    @Override
    public String instanceId() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).instanceId();
    }

    @Override
    public Sku sku() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).sku();
    }

    @Override
    public VirtualMachineSizeTypes size() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).hardwareProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).hardwareProfile().vmSize() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).hardwareProfile().vmSize();
        }
        if (this.sku() != null && this.sku().name() != null) {
            return VirtualMachineSizeTypes.fromString(this.sku().name());
        }
        return null;
    }

    @Override
    public boolean isLatestScaleSetUpdateApplied() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).latestModelApplied();
    }

    @Override
    public boolean isOSBasedOnPlatformImage() {
        ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().imageReference();
        return imageReference != null && imageReference.publisher() != null && imageReference.sku() != null && imageReference.offer() != null && imageReference.version() != null;
    }

    @Override
    public boolean isOSBasedOnCustomImage() {
        ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().imageReference();
        return imageReference != null && imageReference.id() != null;
    }

    @Override
    public boolean isOSBasedOnStoredImage() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk() != null && ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().image() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().image().uri() != null;
        }
        return false;
    }

    @Override
    public ImageReference platformImageReference() {
        if (this.isOSBasedOnPlatformImage()) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().imageReference();
        }
        return null;
    }

    @Override
    public VirtualMachineImage getOSPlatformImage() {
        if (this.isOSBasedOnPlatformImage()) {
            ImageReference imageReference = this.platformImageReference();
            return this.computeManager.virtualMachineImages().getImage(this.region(), imageReference.publisher(), imageReference.offer(), imageReference.sku(), imageReference.version());
        }
        return null;
    }

    @Override
    public VirtualMachineCustomImage getOSCustomImage() {
        if (this.isOSBasedOnCustomImage()) {
            ImageReference imageReference = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().imageReference();
            return (VirtualMachineCustomImage)this.computeManager.virtualMachineCustomImages().getById(imageReference.id());
        }
        return null;
    }

    @Override
    public String storedImageUnmanagedVhdUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().image() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().image().uri();
        }
        return null;
    }

    @Override
    public String osDiskName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().name();
    }

    @Override
    public String osUnmanagedDiskVhdUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().vhd() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().vhd().uri();
        }
        return null;
    }

    @Override
    public String osDiskId() {
        if (this.storageProfile().osDisk().managedDisk() != null) {
            return this.storageProfile().osDisk().managedDisk().id();
        }
        return null;
    }

    @Override
    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, UnmanagedDataDiskImpl> dataDisks = new HashMap<Integer, UnmanagedDataDiskImpl>();
        if (!this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new UnmanagedDataDiskImpl(innerDataDisk, null));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public Map<Integer, VirtualMachineDataDisk> dataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, VirtualMachineDataDiskImpl> dataDisks = new HashMap<Integer, VirtualMachineDataDiskImpl>();
        if (this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new VirtualMachineDataDiskImpl(innerDataDisk));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().caching();
    }

    @Override
    public int osDiskSizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().diskSizeGB());
    }

    @Override
    public String computerName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().computerName();
    }

    @Override
    public String administratorUserName() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().adminUsername();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().osType();
    }

    @Override
    public boolean isLinuxPasswordAuthenticationEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().linuxConfiguration() != null) {
            return !ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().linuxConfiguration().disablePasswordAuthentication());
        }
        return false;
    }

    @Override
    public boolean isWindowsVMAgentProvisioned() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration() != null) {
            return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration().provisionVMAgent());
        }
        return false;
    }

    @Override
    public boolean isWindowsAutoUpdateEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration() != null) {
            return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration().enableAutomaticUpdates());
        }
        return false;
    }

    @Override
    public String windowsTimeZone() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile().windowsConfiguration().timeZone();
        }
        return null;
    }

    @Override
    public boolean bootDiagnosticEnabled() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile().bootDiagnostics() != null) {
            return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile().bootDiagnostics().enabled());
        }
        return false;
    }

    @Override
    public String bootDiagnosticStorageAccountUri() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile() != null && ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile().bootDiagnostics() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile().bootDiagnostics().storageUri();
        }
        return null;
    }

    @Override
    public String availabilitySetId() {
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).availabilitySet() != null) {
            return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).availabilitySet().id();
        }
        return null;
    }

    @Override
    public List<String> networkInterfaceIds() {
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (NetworkInterfaceReference reference : ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).networkProfile().networkInterfaces()) {
            resourceIds.add(reference.id());
        }
        return Collections.unmodifiableList(resourceIds);
    }

    @Override
    public String primaryNetworkInterfaceId() {
        for (NetworkInterfaceReference reference : ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).networkProfile().networkInterfaces()) {
            if (reference.primary() == null || !reference.primary().booleanValue()) continue;
            return reference.id();
        }
        return null;
    }

    @Override
    public Map<String, VirtualMachineScaleSetVMInstanceExtension> extensions() {
        LinkedHashMap<String, VirtualMachineScaleSetVMInstanceExtensionImpl> extensions = new LinkedHashMap<String, VirtualMachineScaleSetVMInstanceExtensionImpl>();
        if (((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).resources() != null) {
            for (VirtualMachineExtensionInner extensionInner : ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).resources()) {
                extensions.put(extensionInner.name(), new VirtualMachineScaleSetVMInstanceExtensionImpl(extensionInner, this));
            }
        }
        return Collections.unmodifiableMap(extensions);
    }

    @Override
    public StorageProfile storageProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile();
    }

    @Override
    public OSProfile osProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).osProfile();
    }

    @Override
    public DiagnosticsProfile diagnosticsProfile() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).diagnosticsProfile();
    }

    private void updateInstanceView(VirtualMachineScaleSetVMInstanceViewInner instanceViewInner) {
        this.virtualMachineInstanceView = new VirtualMachineInstanceViewImpl(new VirtualMachineInstanceViewInner().withBootDiagnostics(instanceViewInner.bootDiagnostics()).withDisks(instanceViewInner.disks()).withExtensions(instanceViewInner.extensions()).withPlatformFaultDomain(instanceViewInner.platformFaultDomain()).withPlatformUpdateDomain(instanceViewInner.platformUpdateDomain()).withRdpThumbPrint(instanceViewInner.rdpThumbPrint()).withStatuses(instanceViewInner.statuses()).withVmAgent(instanceViewInner.vmAgent()).withMaintenanceRedeployStatus(instanceViewInner.maintenanceRedeployStatus()));
    }

    @Override
    public VirtualMachineInstanceView instanceView() {
        if (this.virtualMachineInstanceView == null) {
            this.refreshInstanceView();
        }
        return this.virtualMachineInstanceView;
    }

    @Override
    public VirtualMachineInstanceView refreshInstanceView() {
        return (VirtualMachineInstanceView)this.refreshInstanceViewAsync().block();
    }

    @Override
    public Mono<VirtualMachineInstanceView> refreshInstanceViewAsync() {
        return this.client.getInstanceViewAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId()).map(instanceViewInner -> {
            this.updateInstanceView((VirtualMachineScaleSetVMInstanceViewInner)instanceViewInner);
            return this.virtualMachineInstanceView;
        }).switchIfEmpty(Mono.defer(() -> Mono.empty()));
    }

    @Override
    public PowerState powerState() {
        return PowerState.fromInstanceView(this.instanceView());
    }

    @Override
    public void redeploy() {
        this.redeployAsync().block();
    }

    @Override
    public Mono<Void> redeployAsync() {
        return this.client.redeployAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId());
    }

    @Override
    public void reimage() {
        this.reimageAsync().block();
    }

    @Override
    public Mono<Void> reimageAsync() {
        return this.client.reimageAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId(), null);
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().block();
    }

    @Override
    public Mono<Void> deallocateAsync() {
        return this.client.deallocateAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId());
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().block();
    }

    @Override
    public Mono<Void> powerOffAsync() {
        return this.client.powerOffAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId(), null);
    }

    @Override
    public void powerOff(boolean skipShutdown) {
        this.powerOffAsync(skipShutdown).block();
    }

    @Override
    public Mono<Void> powerOffAsync(boolean skipShutdown) {
        return this.client.powerOffAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId(), skipShutdown);
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return this.client.startAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId());
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return this.client.restartAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId());
    }

    @Override
    public void delete() {
        this.deleteAsync().block();
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.client.deleteAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId());
    }

    public VirtualMachineScaleSetVM refresh() {
        return (VirtualMachineScaleSetVM)this.refreshAsync().block();
    }

    public Mono<VirtualMachineScaleSetVM> refreshAsync() {
        return this.client.getWithResponseAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId(), InstanceViewTypes.INSTANCE_VIEW).map(Response::getValue).map(vmInner -> {
            this.setInner(vmInner);
            this.clearCachedRelatedResources();
            if (vmInner.instanceView() != null) {
                this.updateInstanceView(vmInner.instanceView());
            }
            this.initializeDataDisks();
            return this;
        });
    }

    @Override
    public VirtualMachineScaleSetNetworkInterface getNetworkInterface(String name) {
        return ((VirtualMachineScaleSetImpl)this.parent()).getNetworkInterfaceByInstanceId(this.instanceId(), name);
    }

    @Override
    public Mono<VirtualMachineScaleSetNetworkInterface> getNetworkInterfaceAsync(String name) {
        return ((VirtualMachineScaleSetImpl)this.parent()).getNetworkInterfaceByInstanceIdAsync(this.instanceId(), name);
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetNetworkInterface> listNetworkInterfaces() {
        return ((VirtualMachineScaleSetImpl)this.parent()).listNetworkInterfacesByInstanceId(this.instanceId());
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetNetworkInterface> listNetworkInterfacesAsync() {
        return ((VirtualMachineScaleSetImpl)this.parent()).listNetworkInterfacesByInstanceIdAsync(this.instanceId());
    }

    @Override
    public String modelDefinitionApplied() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).modelDefinitionApplied();
    }

    @Override
    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).protectionPolicy();
    }

    @Override
    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).networkProfileConfiguration();
    }

    @Override
    public OffsetDateTime timeCreated() {
        return ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).timeCreated();
    }

    private void clearCachedRelatedResources() {
        this.virtualMachineInstanceView = null;
    }

    @Override
    public boolean isManagedDiskEnabled() {
        if (this.isOSBasedOnCustomImage()) {
            return true;
        }
        if (this.isOSBasedOnStoredImage()) {
            return false;
        }
        return !this.isOSBasedOnPlatformImage() || ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk() == null || ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().osDisk().vhd() == null;
    }

    @Override
    public VirtualMachineScaleSetVM.Update withExistingDataDisk(Disk dataDisk, int lun, CachingTypes cachingTypes) {
        return this.withExistingDataDisk(dataDisk, lun, cachingTypes, StorageAccountTypes.fromString(dataDisk.sku().accountType().toString()));
    }

    @Override
    public VirtualMachineScaleSetVM.Update withExistingDataDisk(Disk dataDisk, int lun, CachingTypes cachingTypes, StorageAccountTypes storageAccountTypes) {
        if (!this.isManagedDiskEnabled()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine"));
        }
        if (((DiskInner)((Object)dataDisk.innerModel())).diskState() != DiskState.UNATTACHED) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Disk need to be in unattached state"));
        }
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters().withStorageAccountType(storageAccountTypes);
        managedDiskParameters.withId(dataDisk.id());
        DataDisk attachDataDisk = new DataDisk().withCreateOption(DiskCreateOptionTypes.ATTACH).withLun(lun).withCaching(cachingTypes).withManagedDisk(managedDiskParameters);
        return this.withExistingDataDisk(attachDataDisk, lun);
    }

    private VirtualMachineScaleSetVM.Update withExistingDataDisk(DataDisk dataDisk, int lun) {
        if (this.tryFindDataDisk(lun, ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().dataDisks()) != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("A data disk with lun '%d' already attached", lun)));
        }
        if (this.tryFindDataDisk(lun, this.managedDataDisks.existingDisksToAttach) != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("A data disk with lun '%d' already scheduled to be attached", lun)));
        }
        this.managedDataDisks.existingDisksToAttach.add(dataDisk);
        return this;
    }

    @Override
    public VirtualMachineScaleSetVM.Update withoutDataDisk(int lun) {
        DataDisk dataDisk = this.tryFindDataDisk(lun, ((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile().dataDisks());
        if (dataDisk == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("A data disk with lun '%d' not found", lun)));
        }
        if (dataDisk.createOption() != DiskCreateOptionTypes.ATTACH) {
            String exceptionMessage = String.format("A data disk with lun '%d' cannot be detached, as it is part of Virtual Machine Scale Set model", lun);
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(exceptionMessage));
        }
        this.managedDataDisks.diskLunsToRemove.add(lun);
        return this;
    }

    public VirtualMachineScaleSetVM apply() {
        return (VirtualMachineScaleSetVM)this.applyAsync().block();
    }

    public Mono<VirtualMachineScaleSetVM> applyAsync() {
        return this.applyAsync(Context.NONE);
    }

    public VirtualMachineScaleSetVM apply(Context context) {
        return (VirtualMachineScaleSetVM)this.applyAsync(context).block();
    }

    public Mono<VirtualMachineScaleSetVM> applyAsync(Context context) {
        VirtualMachineScaleSetVMImpl self = this;
        this.managedDataDisks.syncToVMDataDisks(((VirtualMachineScaleSetVMInner)((Object)this.innerModel())).storageProfile());
        return ((ComputeManagementClient)((ComputeManager)((VirtualMachineScaleSetImpl)this.parent()).manager()).serviceClient()).getVirtualMachineScaleSetVMs().updateAsync(((VirtualMachineScaleSetImpl)this.parent()).resourceGroupName(), ((VirtualMachineScaleSetImpl)this.parent()).name(), this.instanceId(), (VirtualMachineScaleSetVMInner)((Object)this.innerModel())).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).map(vmInner -> {
            self.setInner(vmInner);
            self.clearCachedRelatedResources();
            self.initializeDataDisks();
            return self;
        });
    }

    public VirtualMachineScaleSetVM.Update update() {
        this.initializeDataDisks();
        return this;
    }

    private void initializeDataDisks() {
        this.managedDataDisks.clear();
    }

    private DataDisk tryFindDataDisk(int lun, List<DataDisk> dataDisks) {
        DataDisk disk = null;
        if (dataDisks != null) {
            for (DataDisk dataDisk : dataDisks) {
                if (dataDisk.lun() != lun) continue;
                disk = dataDisk;
                break;
            }
        }
        return disk;
    }

    private static class ManagedDataDiskCollection {
        private final List<DataDisk> existingDisksToAttach = new ArrayList<DataDisk>();
        private final List<Integer> diskLunsToRemove = new ArrayList<Integer>();

        private ManagedDataDiskCollection() {
        }

        void syncToVMDataDisks(StorageProfile storageProfile) {
            if (storageProfile != null && this.isPending()) {
                if (storageProfile.dataDisks() != null && !this.diskLunsToRemove.isEmpty()) {
                    Iterator<DataDisk> iterator = storageProfile.dataDisks().iterator();
                    while (iterator.hasNext()) {
                        DataDisk dataDisk = iterator.next();
                        if (!this.diskLunsToRemove.contains(dataDisk.lun())) continue;
                        iterator.remove();
                    }
                }
                if (!this.existingDisksToAttach.isEmpty()) {
                    for (DataDisk dataDisk : this.existingDisksToAttach) {
                        if (storageProfile.dataDisks() == null) {
                            storageProfile.withDataDisks(new ArrayList<DataDisk>());
                        }
                        storageProfile.dataDisks().add(dataDisk);
                    }
                }
                this.clear();
            }
        }

        private void clear() {
            this.existingDisksToAttach.clear();
            this.diskLunsToRemove.clear();
        }

        private boolean isPending() {
            return !this.existingDisksToAttach.isEmpty() || !this.diskLunsToRemove.isEmpty();
        }
    }
}

